/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.blocks.keg;

import com.mojang.serialization.MapCodec;
import me.itzme1on.alcocraftplus.core.blocks.keg.KegEntity;
import me.itzme1on.alcocraftplus.core.registries.BlockEntitiesRegistry;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import me.itzme1on.alcocraftplus.core.utils.BeerTypeMapperUtil;
import me.itzme1on.alcocraftplus.core.utils.SidedResultsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Keg
extends BaseEntityBlock {
    public static final MapCodec<Keg> CODEC = Keg.simpleCodec(Keg::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape KEG_SHAPE;
    private static final VoxelShape SHAPE_NORTH;
    private static final VoxelShape SHAPE_EAST;
    private static final VoxelShape SHAPE_SOUTH;
    private static final VoxelShape SHAPE_WEST;

    public Keg(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static VoxelShape rotateShape(Direction to) {
        VoxelShape[] buffer = new VoxelShape[]{SHAPE_NORTH, Shapes.empty()};
        int times = (to.get2DDataValue() - Direction.NORTH.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    @NotNull
    public MapCodec<Keg> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        Rotation rotation = mirror.getRotation((Direction)state.getValue((Property)FACING));
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KegEntity(pos, state);
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide()) {
            return SidedResultsUtil.itemConsume(level);
        }
        BlockEntity entity = level.getBlockEntity(pos);
        if (!(entity instanceof KegEntity)) {
            return SidedResultsUtil.passToDefault();
        }
        KegEntity keg = (KegEntity)entity;
        if (this.canPourBeer(stack, keg)) {
            this.handlePouringBeer(player, hand, keg);
            return SidedResultsUtil.itemSidedSuccess(level);
        }
        if (this.canAddWater(stack, keg)) {
            this.handleAddingWater(level, pos, player, hand, keg);
            return SidedResultsUtil.itemSidedSuccess(level);
        }
        InteractionResult result = this.openKegScreen(state, level, pos, player);
        if (result.consumesAction()) {
            return SidedResultsUtil.itemConsume(level);
        }
        return SidedResultsUtil.passToDefault();
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return SidedResultsUtil.blockSidedSuccess(level);
        }
        return this.openKegScreen(state, level, pos, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && !state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof KegEntity) {
            KegEntity kegEntity = (KegEntity)blockEntity;
            kegEntity.getItems().forEach(stack -> {
                if (!stack.isEmpty()) {
                    Keg.popResource((Level)level, (BlockPos)pos, (ItemStack)stack.copy());
                }
            });
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return Keg.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntitiesRegistry.KEG_ENTITY.get()), (world, pos, st, entity) -> {
            if (entity != null) {
                entity.tick(world, pos, st, (KegEntity)entity);
            }
        });
    }

    private boolean canPourBeer(ItemStack heldItem, KegEntity keg) {
        return heldItem.is((Item)ItemsRegistry.MUG.get()) && keg.beerLevel >= 4;
    }

    private void handlePouringBeer(Player player, InteractionHand hand, KegEntity keg) {
        ItemStack beerStack;
        ItemStack heldItem = player.getItemInHand(hand);
        if (!player.isCreative()) {
            heldItem.shrink(1);
        }
        if (!(beerStack = BeerTypeMapperUtil.getBeerStack(keg.beerType)).isEmpty()) {
            ItemStack pouredBeer = beerStack.copy();
            player.awardStat(Stats.ITEM_USED.get((Object)((Item)ItemsRegistry.MUG.get())));
            if (player.getInventory().add(pouredBeer)) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_DRINK, SoundSource.PLAYERS, 0.5f, 1.0f);
            } else {
                player.drop(pouredBeer, false);
            }
        }
        keg.beerLevel -= 4;
    }

    private boolean canAddWater(ItemStack heldItem, KegEntity keg) {
        return heldItem.is(Items.WATER_BUCKET) && keg.waterLevel <= 24 && keg.beerLevel == 0;
    }

    private void handleAddingWater(Level level, BlockPos pos, Player player, InteractionHand hand, KegEntity keg) {
        keg.waterLevel += 8;
        level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
        ItemStack heldItem = player.getItemInHand(hand);
        if (!player.isCreative()) {
            heldItem.shrink(1);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
        }
        player.gameEvent((Holder)GameEvent.FLUID_PLACE, (Entity)player);
    }

    private InteractionResult openKegScreen(BlockState state, Level level, BlockPos pos, Player player) {
        MenuProvider screenHandlerFactory = state.getMenuProvider(level, pos);
        if (screenHandlerFactory != null) {
            player.openMenu(screenHandlerFactory);
            level.playSound(null, pos, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, 0.8f);
            level.playSound(null, pos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            return SidedResultsUtil.success();
        }
        return SidedResultsUtil.pass();
    }

    static {
        SHAPE_NORTH = KEG_SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)16.0, (double)7.0, (double)9.0, (double)17.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)14.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0), Block.box((double)2.0, (double)4.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0), Block.box((double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)4.0, (double)2.0), Block.box((double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)14.0, (double)15.0), Block.box((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)4.0, (double)15.0), Block.box((double)3.0, (double)14.0, (double)14.0, (double)13.0, (double)15.0, (double)15.0), Block.box((double)14.0, (double)4.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), Block.box((double)3.0, (double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), Block.box((double)13.0, (double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)4.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), Block.box((double)2.0, (double)14.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0), Block.box((double)2.0, (double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0), Block.box((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0), Block.box((double)13.0, (double)3.0, (double)0.0, (double)14.0, (double)4.0, (double)16.0), Block.box((double)7.0, (double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)1.0), Block.box((double)3.0, (double)0.0, (double)2.0, (double)5.0, (double)1.0, (double)4.0), Block.box((double)11.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)4.0), Block.box((double)3.0, (double)1.0, (double)2.0, (double)13.0, (double)2.0, (double)4.0), Block.box((double)3.0, (double)0.0, (double)12.0, (double)5.0, (double)1.0, (double)14.0), Block.box((double)11.0, (double)0.0, (double)12.0, (double)13.0, (double)1.0, (double)14.0), Block.box((double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)2.0, (double)14.0)});
        SHAPE_EAST = Keg.rotateShape(Direction.EAST);
        SHAPE_SOUTH = Keg.rotateShape(Direction.SOUTH);
        SHAPE_WEST = Keg.rotateShape(Direction.WEST);
    }
}

