/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.server;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.util.IllegalFormatException;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.Xplat;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.common.network.packet.s2c.DamageDirectionPayloadS2C;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.Utils;
import org.vivecraft.mixin.world.entity.PlayerMixin;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin {
    @Shadow
    @Final
    public MinecraftServer server;
    @Shadow
    public ServerGamePacketListenerImpl connection;
    @Unique
    private ItemStack vivecraft$roomscaleShieldItem;
    @Unique
    private InteractionHand vivecraft$roomscaleShieldHand;

    protected ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"initInventoryMenu()V"}, at={@At(value="TAIL")})
    private void vivecraft$addItemEasterEgg(CallbackInfo ci) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (((Boolean)ServerConfig.VR_FUN.get()).booleanValue() && serverVivePlayer != null && serverVivePlayer.isVR() && this.random.nextInt(40) == 3) {
            ItemStack easterEggItem;
            if (this.random.nextInt(2) == 1) {
                easterEggItem = new ItemStack((ItemLike)Items.PUMPKIN_PIE);
                easterEggItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"EAT ME"));
            } else {
                easterEggItem = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
                easterEggItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"DRINK ME"));
            }
            if (this.getInventory().add(easterEggItem)) {
                this.inventoryMenu.broadcastChanges();
            }
        }
    }

    @Inject(method={"doTick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;tick()V", shift=At.Shift.AFTER)})
    private void vivecraft$overridePose(CallbackInfo ci) {
        ServerVRPlayers.overridePose((ServerPlayer)this);
    }

    @Override
    protected int vivecraft$modifySweepParticleSpawnPos(ServerLevel instance, ParticleOptions type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, Operation<Integer> original) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (serverVivePlayer != null && serverVivePlayer.isVR()) {
            Vec3 aim = serverVivePlayer.getAimDir(false);
            float yaw = (float)Math.atan2(-aim.x, aim.z);
            xOffset = -Mth.sin((float)yaw);
            zOffset = Mth.cos((float)yaw);
            Vec3 pos = serverVivePlayer.getAimPos(false);
            return (Integer)original.call(new Object[]{instance, type, pos.x + xOffset, pos.y, pos.z + zOffset, particleCount, xOffset, yOffset, zOffset, speed});
        }
        return (Integer)original.call(new Object[]{instance, type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed});
    }

    @Override
    protected float vivecraft$damageModifier(float damage) {
        ServerVivePlayer vivePlayer;
        if (((Boolean)ServerConfig.DUAL_WIELDING.get()).booleanValue() && (Double)ServerConfig.BOOTS_ARMOR_DAMAGE.get() > 0.0 && (vivePlayer = this.vivecraft$getVivePlayer()).isVR() && vivePlayer.activeBodyPart.isFoot() && !this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
            float addedDamage = 0.0f;
            ItemStack boots = this.getItemBySlot(EquipmentSlot.FEET);
            ItemAttributeModifiers modifiers = (ItemAttributeModifiers)boots.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            if (modifiers.modifiers().isEmpty()) {
                modifiers = boots.getItem().getDefaultAttributeModifiers();
            }
            for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                if (!entry.attribute().is(Attributes.ARMOR)) continue;
                float amount = (float)entry.modifier().amount();
                switch (entry.modifier().operation()) {
                    case ADD_VALUE: {
                        addedDamage += amount;
                        break;
                    }
                    case ADD_MULTIPLIED_TOTAL: {
                        addedDamage += amount * addedDamage;
                    }
                }
            }
            return damage + addedDamage * ((Double)ServerConfig.BOOTS_ARMOR_DAMAGE.get()).floatValue();
        }
        return damage;
    }

    @Override
    protected boolean vivecraft$roomscaleShieldBlockingItem(boolean isBlocking, DamageSource damageSource, LocalBooleanRef roomscaleBlocked) {
        this.vivecraft$roomscaleShieldItem = null;
        this.vivecraft$roomscaleShieldHand = null;
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (((Boolean)ServerConfig.ALLOW_ROOMSCALE_SHIELD_BLOCKING.get()).booleanValue() && !isBlocking && damageSource.getSourcePosition() != null && serverVivePlayer != null && serverVivePlayer.isVR()) {
            Entity entity;
            Vec3 dmgPos = damageSource.getSourcePosition();
            boolean isProjectile = false;
            Entity entity2 = damageSource.getDirectEntity();
            if (entity2 instanceof Entity && dmgPos == (entity = entity2).position()) {
                isProjectile = entity instanceof Projectile;
                dmgPos = entity.getBoundingBox().getCenter().subtract(entity.getDeltaMovement().normalize());
            }
            for (int i = 0; i < 2; ++i) {
                InteractionHand hand = InteractionHand.values()[i];
                ItemStack stack = this.getItemBySlot(LivingEntity.getSlotForHand((InteractionHand)hand));
                if (stack == null || stack.getItem().getUseAnimation(stack) != UseAnim.BLOCK || this.getCooldowns().isOnCooldown(stack.getItem())) continue;
                Vector3fc sideDir = serverVivePlayer.isLeftHanded() ? (hand == InteractionHand.MAIN_HAND ? MathUtils.RIGHT : MathUtils.LEFT) : (hand == InteractionHand.MAIN_HAND ? MathUtils.LEFT : MathUtils.RIGHT);
                Vec3 shieldDir = serverVivePlayer.getBodyPartVectorCustom(VRBodyPart.fromInteractionHand(hand), sideDir);
                double angle = 0.0;
                if (isProjectile) {
                    dmgDir = dmgPos.subtract(serverVivePlayer.getBodyPartPos(VRBodyPart.fromInteractionHand(hand))).normalize();
                    angle = shieldDir.dot(dmgDir);
                } else {
                    dmgDir = dmgPos.subtract(this.position());
                    dmgDir = new Vec3(dmgDir.x, 0.0, dmgDir.z).normalize();
                    Vec3 shieldHor = new Vec3(shieldDir.x, 0.0, shieldDir.z).normalize();
                    angle = shieldHor.dot(dmgDir);
                }
                if (!(angle > 0.5)) continue;
                roomscaleBlocked.set(true);
                this.vivecraft$roomscaleShieldItem = stack;
                this.vivecraft$roomscaleShieldHand = hand;
                return true;
            }
        }
        return isBlocking;
    }

    @Override
    protected void vivecraft$roomscaleShieldItemDamage(float damageAmount, Operation<Void> original) {
        if (((Boolean)ServerConfig.ALLOW_ROOMSCALE_SHIELD_BLOCKING.get()).booleanValue() && this.vivecraft$roomscaleShieldItem != null) {
            ItemStack backup = this.useItem;
            this.useItem = this.vivecraft$roomscaleShieldItem;
            original.call(new Object[]{Float.valueOf(damageAmount)});
            this.useItem = backup;
            this.vivecraft$roomscaleShieldItem = null;
            this.vivecraft$roomscaleShieldHand = null;
        } else {
            original.call(new Object[]{Float.valueOf(damageAmount)});
        }
    }

    @Override
    protected InteractionHand vivecraft$roomscaleShieldHand(InteractionHand original) {
        return (Boolean)ServerConfig.ALLOW_ROOMSCALE_SHIELD_BLOCKING.get() != false && this.vivecraft$roomscaleShieldHand != null ? this.vivecraft$roomscaleShieldHand : original;
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$noAttackWhileBlocking(Entity target, CallbackInfo ci) {
        ServerVivePlayer vivePlayer = this.vivecraft$getVivePlayer();
        if (!((Boolean)ServerConfig.ALLOW_ATTACKS_WHILE_BLOCKING.get()).booleanValue() && vivePlayer != null && vivePlayer.isVR() && this.isBlocking()) {
            ci.cancel();
        }
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")})
    private void vivecraft$dropVive(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<ItemEntity> cir, @Local ItemEntity item) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (!dropAround && serverVivePlayer != null && serverVivePlayer.isVR()) {
            Vec3 pos = serverVivePlayer.getAimPos(false);
            Vec3 aim = serverVivePlayer.getAimDir(false);
            float speed = 0.3f;
            item.setDeltaMovement(aim.x * (double)0.3f, aim.y * (double)0.3f, aim.z * (double)0.3f);
            item.setPos(pos.x + item.getDeltaMovement().x, pos.y + item.getDeltaMovement().y, pos.z + item.getDeltaMovement().z);
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$checkCanGetHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.getEntity();
        ServerPlayer other = null;
        if (entity instanceof ServerPlayer) {
            other = (ServerPlayer)entity;
        } else if (entity instanceof AbstractArrow && ((AbstractArrow)entity).getOwner() instanceof ServerPlayer) {
            other = (ServerPlayer)((AbstractArrow)entity).getOwner();
        }
        if (other != null) {
            ServerVivePlayer otherVive = ServerVRPlayers.getVivePlayer(other);
            ServerVivePlayer thisVive = this.vivecraft$getVivePlayer();
            if (otherVive == null) {
                otherVive = new ServerVivePlayer(other);
            }
            if (thisVive == null) {
                thisVive = new ServerVivePlayer((ServerPlayer)this);
            }
            boolean blockedDamage = false;
            String blockedDamageCase = "";
            if (!otherVive.isVR() && thisVive.isVR() && thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_SEATEDVR_VS_NONVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled nonvr vs seated VR damage";
                }
            } else if (!otherVive.isVR() && thisVive.isVR() && !thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_NONVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled nonvr vs standing VR damage";
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated() || thisVive.isVR() && thisVive.isSeated() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_SEATEDVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled seated VR vs standing VR damage";
                }
            } else if (otherVive.isVR() && !otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_VR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled standing VR vs standing VR damage";
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && thisVive.isSeated() && !((Boolean)ServerConfig.PVP_SEATEDVR_VS_SEATEDVR.get()).booleanValue()) {
                blockedDamage = true;
                blockedDamageCase = "canceled seated VR vs seated VR damage";
            }
            if (blockedDamage) {
                if (((Boolean)ServerConfig.PVP_NOTIFY_BLOCKED_DAMAGE.get()).booleanValue()) {
                    other.sendSystemMessage((Component)Component.literal((String)blockedDamageCase));
                }
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="RETURN")})
    private void vivecraft$sendDamageDir(CallbackInfoReturnable<Boolean> cir, @Local(argsOnly=true) DamageSource damageSource) {
        ServerVivePlayer vivePlayer;
        if (cir.getReturnValueZ() && (vivePlayer = this.vivecraft$getVivePlayer()) != null && vivePlayer.isVR() && vivePlayer.wantsDamageDirection) {
            this.connection.send(Xplat.getS2CPacket(new DamageDirectionPayloadS2C(Utils.getDirFromDamageSource(damageSource, this))));
        }
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    private void vivecraft$customDeathMessage(DamageSource damageSource, CallbackInfo ci) {
        if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue()) {
            ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer((ServerPlayer)this);
            String message = "";
            String entity = "";
            if (damageSource.getEntity() != null) {
                entity = damageSource.getEntity().getName().plainCopy().getString();
                message = vivePlayer == null ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_SEATED.get() : (String)ServerConfig.MESSAGES_DEATH_BY_MOB_VR.get()));
            }
            if (message.isEmpty()) {
                message = vivePlayer == null ? (String)ServerConfig.MESSAGES_DEATH_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_DEATH_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_DEATH_SEATED.get() : (String)ServerConfig.MESSAGES_DEATH_VR.get()));
            }
            if (!message.isEmpty()) {
                try {
                    this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)message.formatted(this.getName().getString(), entity)), false);
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: Death message '{}' has errors:", (Object)message, (Object)e);
                }
            }
        }
    }

    @Unique
    private ServerVivePlayer vivecraft$getVivePlayer() {
        return ServerVRPlayers.getVivePlayer((ServerPlayer)this);
    }
}

