/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.world;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.MCVR;

@Mixin(value={FishingHook.class})
public abstract class FishingHookVRMixin
extends Entity {
    @Shadow
    private boolean biting;
    @Unique
    private boolean vivecraft$wasBiting = false;
    @Unique
    private boolean vivecraft$wasNibble = false;

    @Shadow
    public abstract Player getPlayerOwner();

    public FishingHookVRMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void vivecraft$fishhookFeedback(CallbackInfo ci) {
        if (!VRState.VR_RUNNING) {
            return;
        }
        Player player = this.getPlayerOwner();
        if (player != null && player.isLocalPlayer()) {
            if (this.biting && !this.vivecraft$wasBiting) {
                MCVR.get().triggerHapticPulse(player.getMainHandItem().getItem() instanceof FishingRodItem ? ControllerType.RIGHT : ControllerType.LEFT, 0.005f, 160.0f, 0.5f);
            } else if (this.getDeltaMovement().y < -0.01 && !this.vivecraft$wasNibble) {
                MCVR.get().triggerHapticPulse(player.getMainHandItem().getItem() instanceof FishingRodItem ? ControllerType.RIGHT : ControllerType.LEFT, 5.0E-4f, 160.0f, 0.05f);
                this.vivecraft$wasNibble = true;
            }
        }
        this.vivecraft$wasBiting = this.biting;
        this.vivecraft$wasNibble = this.vivecraft$wasNibble && this.getDeltaMovement().y < 0.0;
    }
}

