/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.gui.screens.inventory;

import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeModeInventoryScreenVRMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu> {
    @Shadow
    private EditBox searchBox;
    @Shadow
    private static CreativeModeTab selectedTab;

    public CreativeModeInventoryScreenVRMixin(CreativeModeInventoryScreen.ItemPickerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    @Inject(method={"refreshSearchResults()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;scrollOffs:F")})
    private void vivecraft$addVivecraftItemsSearch(CallbackInfo ci) {
        if (selectedTab == null || selectedTab.getType() == CreativeModeTab.Type.SEARCH) {
            this.vivecraft$addCreativeSearch(this.searchBox.getValue(), (NonNullList<ItemStack>)((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).items);
        }
    }

    @Inject(method={"selectTab(Lnet/minecraft/world/item/CreativeModeTab;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;addAll(Ljava/util/Collection;)Z", ordinal=1, shift=At.Shift.AFTER)})
    private void vivecraft$addVivecraftItemsCategory(CreativeModeTab tab, CallbackInfo ci) {
        this.vivecraft$addCreativeItems(tab, (NonNullList<ItemStack>)((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).items);
    }

    @Unique
    private void vivecraft$addCreativeItems(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (tab == BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.FOOD_AND_DRINKS) || tab == null) {
            ItemStack eatMeCake = new ItemStack((ItemLike)Items.PUMPKIN_PIE);
            eatMeCake.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"EAT ME"));
            ItemStack drinkMePotion = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
            drinkMePotion.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"DRINK ME"));
            items.add((Object)eatMeCake);
            items.add((Object)drinkMePotion);
        }
        if (tab == BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.TOOLS_AND_UTILITIES) || tab == null) {
            ItemStack boots = new ItemStack((ItemLike)Items.LEATHER_BOOTS);
            boots.set(DataComponents.CUSTOM_NAME, (Object)Component.translatableWithFallback((String)"vivecraft.item.jumpboots", (String)"Jump Boots"));
            boots.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
            boots.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(9233775, false));
            ItemStack claws = new ItemStack((ItemLike)Items.SHEARS);
            claws.set(DataComponents.CUSTOM_NAME, (Object)Component.translatableWithFallback((String)"vivecraft.item.climbclaws", (String)"Climb Claws"));
            claws.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
            items.add((Object)boots);
            items.add((Object)claws);
        }
    }

    @Unique
    private void vivecraft$addCreativeSearch(String query, NonNullList<ItemStack> itmes) {
        NonNullList vivecraftItems = NonNullList.create();
        this.vivecraft$addCreativeItems(null, (NonNullList<ItemStack>)vivecraftItems);
        for (ItemStack item : vivecraftItems) {
            if (!query.isEmpty() && !item.getHoverName().toString().toLowerCase().contains(query.toLowerCase())) continue;
            itmes.add((Object)item);
        }
    }
}

