/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FogType;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_xr.render_pass.RenderPassType;

public class XRCamera
extends Camera {
    public void setup(BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (RenderPassType.isVanilla()) {
            super.setup(level, entity, detached, thirdPersonReverse, partialTick);
            return;
        }
        this.initialized = true;
        this.level = level;
        this.entity = entity;
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        RenderPass renderpass = dataholder.currentPass;
        VRData.VRDevicePose eye = dataholder.vrPlayer.getVRDataWorld().getEye(renderpass);
        this.setPosition(eye.getPosition());
        this.setRotation(eye.getYaw(), -eye.getPitch());
    }

    public void tick() {
        if (RenderPassType.isVanilla()) {
            super.tick();
        }
    }

    public boolean isDetached() {
        if (RenderPassType.isVanilla()) {
            return super.isDetached();
        }
        boolean renderSelf = RenderPass.renderPlayer(ClientDataHolderVR.getInstance().currentPass);
        return renderSelf &= !RenderPass.isFirstPerson(ClientDataHolderVR.getInstance().currentPass) || !(this.getEntity() instanceof LivingEntity) || !((LivingEntity)this.getEntity()).isSleeping();
    }

    public FogType getFluidInCamera() {
        if (this.level == null) {
            return FogType.NONE;
        }
        return super.getFluidInCamera();
    }
}

