/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils.math;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;

public class BezierCurve {
    public ArrayList<Node> nodes = new ArrayList();
    boolean circular;

    public BezierCurve(Node[] nodes, boolean circular) {
        this.nodes.addAll(Arrays.asList(nodes));
        this.circular = circular;
    }

    public BezierCurve(boolean circular) {
        this.circular = circular;
    }

    Vec3 getIntermediate(Node n1, Node n2, double perc) {
        Vec3 p0 = n1.vertex;
        Vec3 p1 = n1.controlOut;
        Vec3 p2 = n2.controlIn;
        Vec3 p3 = n2.vertex;
        return p0.scale(Math.pow(1.0 - perc, 3.0)).add(p1.scale(3.0 * Math.pow(1.0 - perc, 2.0) * perc)).add(p2.scale(3.0 * (1.0 - perc) * Math.pow(perc, 2.0))).add(p3.scale(Math.pow(perc, 3.0)));
    }

    public Vec3 getPointOnPath(double perc) {
        int upperIndex;
        int nodeCount = this.circular ? this.nodes.size() : this.nodes.size() - 1;
        double exactIndex = perc * (double)nodeCount;
        int lowerIndex = (int)Math.floor(exactIndex) % this.nodes.size();
        if (lowerIndex == (upperIndex = (int)Math.ceil(exactIndex) % this.nodes.size())) {
            return this.nodes.get((int)lowerIndex).vertex;
        }
        Node node1 = this.nodes.get(lowerIndex);
        Node node2 = this.nodes.get(upperIndex);
        return this.getIntermediate(node1, node2, exactIndex - (double)lowerIndex);
    }

    public Vec3[] getLinearInterpolation(int verticesPerNode) {
        if (this.nodes.isEmpty()) {
            return new Vec3[0];
        }
        int totalVertices = verticesPerNode * (this.circular ? this.nodes.size() : this.nodes.size() - 1) + 1;
        Vec3[] out = new Vec3[totalVertices];
        for (int i = 0; i < totalVertices; ++i) {
            double perc = (double)i / (double)Math.max(1, totalVertices - 1);
            out[i] = this.getPointOnPath(perc);
        }
        return out;
    }

    public void render(int vertexCount, Color c, float partialTick) {
        LocalPlayer player = Minecraft.getInstance().player;
        double x = player.xOld + (player.getX() - player.xOld) * (double)partialTick;
        double y = player.yOld + (player.getY() - player.yOld) * (double)partialTick;
        double z = player.zOld + (player.getZ() - player.zOld) * (double)partialTick;
        RenderSystem.depthMask((boolean)false);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR);
        Vec3[] avec3 = this.getLinearInterpolation(vertexCount / this.nodes.size());
        for (int i = 0; i < avec3.length; ++i) {
            this.renderVertex((VertexConsumer)buffer, avec3[i], c, x, y, z);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.depthMask((boolean)true);
    }

    void renderVertex(VertexConsumer buffer, Vec3 vert, Color color, double offX, double offY, double offZ) {
        buffer.addVertex((float)(vert.x - offX), (float)(vert.y - offY), (float)(vert.z - offZ)).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static class Node {
        Vec3 vertex;
        Vec3 controlIn;
        Vec3 controlOut;

        public Node(Vec3 vertex, Vec3 controlIn, Vec3 controlOut) {
            this.vertex = vertex;
            this.controlIn = controlIn;
            this.controlOut = controlOut;
        }

        public Node(Vec3 vertex, Vec3 controlDir, double controlLenIn, double controlLenOut) {
            this(vertex, vertex.add(controlDir.normalize().scale(-controlLenIn)), vertex.add(controlDir.normalize().scale(controlLenOut)));
        }
    }
}

