/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.screens;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.vivecraft.client.gui.framework.widgets.TextScrollWidget;

public class ServerVrChangesScreen
extends Screen {
    private final String changes;
    private final Screen lastScreen;

    public ServerVrChangesScreen(Map<String, String> changes) {
        super((Component)Component.translatable((String)"vivecraft.messages.nondefaultvrchanges.title"));
        this.lastScreen = Minecraft.getInstance().screen;
        StringBuilder builder = new StringBuilder();
        changes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            builder.append(I18n.get((String)("vivecraft.serverSettings." + (String)entry.getKey()), (Object[])new Object[0])).append(": \u00a7c");
            if ("true".equals(entry.getValue()) || "false".equals(entry.getValue())) {
                builder.append(I18n.get((String)(Boolean.parseBoolean((String)entry.getValue()) ? "options.on" : "options.off"), (Object[])new Object[0]));
            } else {
                builder.append((String)entry.getValue());
            }
            builder.append("\u00a7r\n");
        });
        this.changes = builder.toString();
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)new TextScrollWidget(this.width / 2 - 155, 30, 310, this.height - 30 - 36, this.changes));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"vivecraft.gui.ok"), p -> this.onClose()).pos(this.width / 2 - 75, this.height - 32).size(150, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, -1);
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }
}

