/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.vivecraft.client.gui.framework.screens.ChangeableParentScreen;
import org.vivecraft.client.gui.framework.widgets.TextScrollWidget;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class ErrorScreen
extends Screen
implements ChangeableParentScreen {
    private final Component error;
    private Screen lastScreen;

    public ErrorScreen(Component title, Component error) {
        super(title);
        this.lastScreen = Minecraft.getInstance().screen;
        this.error = error;
    }

    @Override
    public void setParent(Screen parent) {
        this.lastScreen = parent;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)new TextScrollWidget(this.width / 2 - 155, 30, 310, this.height - 30 - 36, this.error));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.back"), p -> this.onClose()).pos(this.width / 2 + 5, this.height - 32).size(150, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"chat.copy.click"), p -> Minecraft.getInstance().keyboardHandler.setClipboard(this.title.getString() + "\n" + this.error.getString())).pos(this.width / 2 - 155, this.height - 32).size(150, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, -1);
    }

    public void onClose() {
        ClientDataHolderVR.getInstance().cachedScreen = null;
        this.minecraft.setScreen(this.lastScreen);
    }
}

