/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import dan200.computercraft.shared.platform.ContainerTransfer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ForgeContainerTransfer
implements ContainerTransfer.Slotted {
    private final IItemHandler handler;
    private final int offset;
    private final int limit;
    private final int slots;

    public ForgeContainerTransfer(IItemHandler handler) {
        this(handler, 0, handler.getSlots(), handler.getSlots());
    }

    public ForgeContainerTransfer(IItemHandler handler, int offset, int limit, int slots) {
        this.handler = handler;
        this.offset = offset;
        this.limit = limit;
        this.slots = slots;
    }

    private int mapSlot(int slot) {
        if (slot < 0 || slot >= this.limit) {
            throw new IllegalArgumentException("slot is out of bounds");
        }
        if ((slot += this.offset) >= this.slots) {
            slot -= this.limit;
        }
        return slot;
    }

    @Override
    public ForgeContainerTransfer rotate(int offset) {
        return offset == 0 ? this : new ForgeContainerTransfer(this.handler, this.mapSlot(offset), this.limit, this.slots);
    }

    @Override
    public ForgeContainerTransfer singleSlot(int slot) {
        return slot == 0 && this.limit == 1 ? this : new ForgeContainerTransfer(this.handler, this.mapSlot(slot), 1, this.slots);
    }

    @Override
    public int moveTo(ContainerTransfer destination, int maxAmount) {
        return ForgeContainerTransfer.moveItem(this, (ForgeContainerTransfer)destination, maxAmount);
    }

    public static int moveItem(ForgeContainerTransfer src, ForgeContainerTransfer dest, int maxAmount) {
        int targetSlot = 0;
        ItemStack movedStack = ItemStack.EMPTY;
        int moved = 0;
        block0: for (int srcSlot = 0; srcSlot < src.limit; ++srcSlot) {
            int actualSrcSlot = src.mapSlot(srcSlot);
            ItemStack stack = src.handler.extractItem(actualSrcSlot, maxAmount, true);
            if (stack.isEmpty()) continue;
            if (movedStack.isEmpty()) {
                movedStack = stack.copy();
                if (stack.getMaxStackSize() < maxAmount) {
                    maxAmount = stack.getMaxStackSize();
                }
            } else if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)movedStack)) continue;
            while (targetSlot < dest.limit) {
                int oldCount = stack.getCount();
                stack = dest.handler.insertItem(dest.mapSlot(targetSlot), stack, false);
                int transferred = oldCount - stack.getCount();
                ItemStack extracted = src.handler.extractItem(actualSrcSlot, transferred, false);
                moved += transferred;
                if (extracted.getCount() < transferred) break block0;
                if (moved >= maxAmount) {
                    return moved;
                }
                if (stack.isEmpty()) continue block0;
                ++targetSlot;
            }
        }
        if (moved == 0) {
            return movedStack.isEmpty() ? -1 : -2;
        }
        return moved;
    }
}

