/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.myr.createmechanicalcompanion.entity.CustomWolf;
import net.myr.createmechanicalcompanion.item.ModItems;
import net.myr.createmechanicalcompanion.screen.ModMenuTypes;
import net.myr.createmechanicalcompanion.sounds.ModSounds;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class WolfMenu
extends AbstractContainerMenu {
    public final CustomWolf wolf;
    public static final int slotAmount = 9;
    private int firstColumnXPosition = 84;
    private int secondColumnXPosition = 108;
    private int thirdColumnXPosition = 132;
    private int firstRowYPosition = 10;
    private int secondRowYPosition = 32;
    private int thirdRowYPosition = 54;

    public WolfMenu(int pContainerId, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this(pContainerId, inv, WolfMenu.getWolfEntity(extraData, inv.player.level()), (ContainerData)new SimpleContainerData(9));
    }

    private static CustomWolf getWolfEntity(RegistryFriendlyByteBuf buf, Level level) {
        int entityId = buf.readVarInt();
        Entity entity = level.getEntity(entityId);
        if (entity instanceof CustomWolf) {
            return (CustomWolf)entity;
        }
        throw new IllegalStateException("Entity with ID " + entityId + " is not a CustomWolfEntity!");
    }

    public WolfMenu(int pContainerId, Inventory playerInventory, CustomWolf wolf, ContainerData data) {
        super(ModMenuTypes.WOLF_MENU.get(), pContainerId);
        this.wolf = wolf;
        this.addWolfInventorySlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    private void addWolfInventorySlots() {
        ItemStackHandler itemHandler = this.wolf.getItemHandler();
        if (itemHandler == null) {
            System.err.println("ItemHandler is null!");
            return;
        }
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, this.firstColumnXPosition, this.firstRowYPosition){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == ModItems.REINFORCED_PLATES.get() || stack.getItem() == ModItems.NETHERITE_PLATES.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 1, this.firstColumnXPosition, this.secondRowYPosition){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == ModItems.MOUNTED_CROSSBOW.get() || stack.getItem() == ModItems.SMELTING_FANGS.get() || stack.getItem() == ModItems.TESLA_TAIL.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 2, this.secondColumnXPosition, this.secondRowYPosition){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == ModItems.MOUNTED_CROSSBOW.get() || stack.getItem() == ModItems.SMELTING_FANGS.get() || stack.getItem() == ModItems.TESLA_TAIL.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 3, this.thirdColumnXPosition, this.secondRowYPosition){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == ModItems.MOUNTED_CROSSBOW.get() || stack.getItem() == ModItems.SMELTING_FANGS.get() || stack.getItem() == ModItems.TESLA_TAIL.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 4, this.secondColumnXPosition, this.firstRowYPosition){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == ModItems.BOOSTER_ROCKET.get() || stack.getItem() == ModItems.QUANTUM_DRIVE.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 5, this.thirdColumnXPosition, this.firstRowYPosition){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == ModItems.BOOSTER_ROCKET.get() || stack.getItem() == ModItems.QUANTUM_DRIVE.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 6, this.firstColumnXPosition, this.thirdRowYPosition){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() == ModItems.REGENERATIVE_CASING.get() || stack.getItem() == ModItems.MOB_RADAR.get() || stack.getItem() == ModItems.MOUNTED_LIGHT.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 7, this.secondColumnXPosition, this.thirdRowYPosition){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == ModItems.REGENERATIVE_CASING.get() || stack.getItem() == ModItems.MOB_RADAR.get() || stack.getItem() == ModItems.MOUNTED_LIGHT.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 8, this.thirdColumnXPosition, this.thirdRowYPosition){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == ModItems.REGENERATIVE_CASING.get() || stack.getItem() == ModItems.MOB_RADAR.get() || stack.getItem() == ModItems.MOUNTED_LIGHT.get();
            }

            public void setByPlayer(ItemStack pStack, ItemStack pOldStack) {
                WolfMenu.this.playInsertSound();
                super.setByPlayer(pStack, pOldStack);
            }
        });
    }

    private void playInsertSound() {
        if (this.wolf.level().isClientSide) {
            float pitch = 0.95f + this.wolf.getRandom().nextFloat() * 0.1f;
            Minecraft.getInstance().level.playLocalSound(this.wolf.blockPosition(), ModSounds.EQUIP_MODULE.get(), SoundSource.PLAYERS, 0.8f, pitch, false);
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (pIndex < 9 ? !this.moveItemStackTo(originalStack, 9, 45, true) : !this.moveItemStackTo(originalStack, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 90 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 148));
        }
    }

    public boolean stillValid(Player pPlayer) {
        return this.wolf.isAlive() && this.wolf.distanceTo((Entity)pPlayer) < 8.0f;
    }
}

