/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.Level;
import net.myr.createmechanicalcompanion.CreateMechanicalCompanion;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlueprintPaintingVariants {
    public static final DeferredRegister<PaintingVariant> BLUEPRINT_PAINTINGS = DeferredRegister.create((ResourceKey)Registries.PAINTING_VARIANT, (String)"createmechanicalcompanion");
    public static final DeferredHolder<PaintingVariant, PaintingVariant> BLUEPRINT_ART_0 = BLUEPRINT_PAINTINGS.register("blueprint_art_0", () -> new PaintingVariant(4, 3, CreateMechanicalCompanion.genRL("blueprint_art_0")));
    public static final DeferredHolder<PaintingVariant, PaintingVariant> BLUEPRINT_ART_1 = BLUEPRINT_PAINTINGS.register("blueprint_art_1", () -> new PaintingVariant(2, 2, CreateMechanicalCompanion.genRL("blueprint_art_1")));
    public static final DeferredHolder<PaintingVariant, PaintingVariant> BLUEPRINT_ART_2 = BLUEPRINT_PAINTINGS.register("blueprint_art_2", () -> new PaintingVariant(2, 1, CreateMechanicalCompanion.genRL("blueprint_art_2")));
    public static final DeferredHolder<PaintingVariant, PaintingVariant> BLUEPRINT_ART_3 = BLUEPRINT_PAINTINGS.register("blueprint_art_3", () -> new PaintingVariant(1, 2, CreateMechanicalCompanion.genRL("blueprint_art_3")));
    public static final DeferredHolder<PaintingVariant, PaintingVariant> BLUEPRINT_ART_4 = BLUEPRINT_PAINTINGS.register("blueprint_art_4", () -> new PaintingVariant(1, 1, CreateMechanicalCompanion.genRL("blueprint_art_4")));
    public static final ResourceLocation RL_ART_0 = CreateMechanicalCompanion.genRL("blueprint_art_0");
    public static final ResourceLocation RL_ART_1 = CreateMechanicalCompanion.genRL("blueprint_art_1");
    public static final ResourceLocation RL_ART_2 = CreateMechanicalCompanion.genRL("blueprint_art_2");
    public static final ResourceLocation RL_ART_3 = CreateMechanicalCompanion.genRL("blueprint_art_3");
    public static final ResourceLocation RL_ART_4 = CreateMechanicalCompanion.genRL("blueprint_art_4");

    public static List<Holder<PaintingVariant>> getAllVariants(Level level) {
        Optional maybeRegistry = level.registryAccess().registry(Registries.PAINTING_VARIANT);
        Object[][] defs = new Object[][]{{RL_ART_0, 4, 3}, {RL_ART_1, 2, 2}, {RL_ART_2, 2, 1}, {RL_ART_3, 1, 2}, {RL_ART_4, 1, 1}};
        ArrayList<Holder<PaintingVariant>> result = new ArrayList<Holder<PaintingVariant>>(defs.length);
        if (maybeRegistry.isPresent()) {
            Registry registry = (Registry)maybeRegistry.get();
            for (Object[] d : defs) {
                ResourceLocation rl = (ResourceLocation)d[0];
                int w = (Integer)d[1];
                int h = (Integer)d[2];
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)rl);
                registry.getHolder(key).ifPresentOrElse(result::add, () -> result.add(Holder.direct((Object)new PaintingVariant(w, h, rl))));
            }
        } else {
            for (Object[] d : defs) {
                ResourceLocation rl = (ResourceLocation)d[0];
                int w = (Integer)d[1];
                int h = (Integer)d[2];
                result.add((Holder<PaintingVariant>)Holder.direct((Object)new PaintingVariant(w, h, rl)));
            }
        }
        return result;
    }

    public static void register(IEventBus eventBus) {
        BLUEPRINT_PAINTINGS.register(eventBus);
    }
}

