/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.entity;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class TargetedArrowEntity
extends Arrow {
    private UUID targetUUID;

    public TargetedArrowEntity(EntityType<? extends TargetedArrowEntity> type, Level level) {
        super(type, level);
    }

    public TargetedArrowEntity(Level level, LivingEntity shooter, LivingEntity target) {
        super(level, shooter, new ItemStack((ItemLike)Items.ARROW), null);
        this.targetUUID = target.getUUID();
    }

    protected void onHitEntity(EntityHitResult result) {
        if (result.getEntity().getUUID().equals(this.targetUUID)) {
            super.onHitEntity(result);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.targetUUID != null) {
            tag.putUUID("TargetUUID", this.targetUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("TargetUUID")) {
            this.targetUUID = tag.getUUID("TargetUUID");
        }
    }
}

