/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class IllagerWorkshopMapTrade
implements VillagerTrades.ItemListing {
    @Nullable
    public MerchantOffer getOffer(Entity pTrader, RandomSource pRandom) {
        Level level = pTrader.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel world = (ServerLevel)level;
        ResourceLocation structureId = ResourceLocation.fromNamespaceAndPath((String)"createmechanicalcompanion", (String)"illager_workshop");
        TagKey structKey = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)structureId);
        BlockPos traderPos = pTrader.blockPosition();
        BlockPos target = world.findNearestMapStructure(structKey, traderPos, 10000, false);
        if (target == null) {
            return null;
        }
        ItemStack map = MapItem.create((Level)world, (int)target.getX(), (int)target.getZ(), (byte)2, (boolean)true, (boolean)true);
        MapItem.renderBiomePreviewMap((ServerLevel)world, (ItemStack)map);
        MapItemSavedData.addTargetDecoration((ItemStack)map, (BlockPos)target, (String)"+", (Holder)MapDecorationTypes.TARGET_X);
        map.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.createmechanicalcompanion.illager_workshop_map"));
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), Optional.of(new ItemCost((ItemLike)Items.COMPASS)), map, 1, 12, 0.2f);
    }
}

