/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.entity;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IllagerEngineer
extends Vindicator {
    public IllagerEngineer(EntityType<? extends Vindicator> type, Level level) {
        super(type, level);
        this.equipWrench();
    }

    private void equipWrench() {
        ItemStack wrench = new ItemStack((ItemLike)AllItems.WRENCH.get());
        this.setItemInHand(InteractionHand.MAIN_HAND, wrench);
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.populateDefaultEquipmentSlots(pRandom, pDifficulty);
        this.equipWrench();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        SpawnGroupData data = super.finalizeSpawn(level, difficulty, reason, spawnData);
        this.equipWrench();
        return data;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.equipWrench();
    }

    public void tick() {
        super.tick();
        if (this.getMainHandItem().isEmpty() || !this.getMainHandItem().is((Item)AllItems.WRENCH.get())) {
            this.equipWrench();
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Vindicator.createAttributes().add(Attributes.ATTACK_DAMAGE, 13.0);
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, source, recentlyHit);
        this.spawnAtLocation((ItemLike)AllItems.CRUSHED_COPPER.get(), 1 + this.random.nextInt(3));
        this.spawnAtLocation((ItemLike)AllItems.CRUSHED_IRON.get(), 1 + this.random.nextInt(3));
        this.spawnAtLocation((ItemLike)AllItems.CRUSHED_ZINC.get(), 1 + this.random.nextInt(3));
        this.spawnAtLocation((ItemLike)AllBlocks.COGWHEEL.get(), 1 + this.random.nextInt(3));
    }

    public boolean canBeLeader() {
        return false;
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }
}

