/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.entity;

import com.simibubi.create.AllItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.myr.createmechanicalcompanion.ModConfig;
import net.myr.createmechanicalcompanion.entity.CustomLeapAtTargetGoal;
import net.myr.createmechanicalcompanion.entity.StrollUnlessMenuOpenGoal;
import net.myr.createmechanicalcompanion.entity.TargetedArrowEntity;
import net.myr.createmechanicalcompanion.item.ModItems;
import net.myr.createmechanicalcompanion.screen.WolfMenu;
import net.myr.createmechanicalcompanion.sounds.ModSounds;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CustomWolf
extends Wolf
implements MenuProvider {
    private static final int DEFENSIVE_SLOT = 0;
    private static final int ATTACK_SLOT = 1;
    private static final int ATTACK_SLOT2 = 2;
    private static final int MOVEMENT_SLOT = 3;
    private static final int MOVEMENT_SLOT2 = 4;
    private static final int UTILITY_SLOT = 5;
    private static final int UTILITY_SLOT2 = 6;
    private static final int UTILITY_SLOT3 = 7;
    private static final int UTILITY_SLOT4 = 8;
    private static final double movementSpeed = 0.35;
    private BlockPos previousLightPos = null;
    private float currentTorchTick = 0.0f;
    private float mountedCrossbowTick = 0.0f;
    private float boosterTimer = 0.0f;
    private float boosterAnimationTick = 0.0f;
    private float quantumDriveTimer = 0.0f;
    private float quantumDriveParticleTimer = 0.0f;
    private float mobRadarTimer = 0.0f;
    private final int slotAmount = 9;
    private ItemStackHandler itemHandler = new ItemStackHandler(9);
    protected final ContainerData data = new ContainerData(this){
        private final int[] values = new int[9];

        public int get(int pIndex) {
            if (pIndex >= 0 && pIndex < this.values.length) {
                return this.values[pIndex];
            }
            throw new IndexOutOfBoundsException("Invalid index for ContainerData: " + pIndex);
        }

        public void set(int pIndex, int pValue) {
            if (pIndex < 0 || pIndex >= this.values.length) {
                throw new IndexOutOfBoundsException("Invalid index for ContainerData: " + pIndex);
            }
            this.values[pIndex] = pValue;
        }

        public int getCount() {
            return this.values.length;
        }
    };
    private static final EntityDataAccessor<CompoundTag> ITEM_HANDLER_DATA = SynchedEntityData.defineId(CustomWolf.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);

    public CustomWolf(EntityType<? extends Wolf> entityType, Level level) {
        super(entityType, level);
    }

    public void tameToPlayer(Player player) {
        this.setTame(true, true);
        this.setOwnerUUID(player.getUUID());
        this.setTarget(null);
        this.navigation.stop();
        this.setOrderedToSit(false);
        this.setPersistenceRequired();
    }

    public boolean wantsToAttack(LivingEntity pTarget, LivingEntity pOwner) {
        if (!this.isBlacklisted((Entity)pTarget)) {
            if (pTarget instanceof Wolf) {
                Wolf wolf = (Wolf)pTarget;
                return !wolf.isTame() || wolf.getOwner() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).canHarmPlayer((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).isTamed()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).isTame();
        }
        return false;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Wolf.createAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ARMOR, 0.0);
    }

    protected double getDefaultGravity() {
        return 0.08;
    }

    public void load(CompoundTag pCompound) {
        super.load(pCompound);
        if (pCompound.contains("previousLightPosition")) {
            int[] coordinates = pCompound.getIntArray("previousLightPosition");
            this.previousLightPos = new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
        }
        if (pCompound.contains("inventory")) {
            this.itemHandler.deserializeNBT((HolderLookup.Provider)this.registryAccess(), pCompound.getCompound("inventory"));
        }
        CustomWolf.removeLightBlocksAround((Entity)this, 3);
    }

    public boolean isBlacklisted(Entity entity) {
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (id == null) {
            return false;
        }
        return ((List)ModConfig.COMMON.wolfBlacklist.get()).contains(id.toString());
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.put("inventory", (Tag)this.itemHandler.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        if (this.previousLightPos != null) {
            int[] previousLightPositionCoordinates = new int[]{this.previousLightPos.getX(), this.previousLightPos.getY(), this.previousLightPos.getZ()};
            pCompound.putIntArray("previousLightPosition", previousLightPositionCoordinates);
        }
        super.addAdditionalSaveData(pCompound);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void setItemHandler(ItemStackHandler handler) {
        if (handler != null) {
            this.itemHandler = handler;
            this.syncItemHandler();
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new WolfMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.getItemInHand(hand).getItem() == AllItems.WRENCH.get()) {
                this.heal(((Double)ModConfig.COMMON.wrenchHealAmount.get()).floatValue());
                this.level().playSound((Entity)this, this.blockPosition(), SoundEvents.IRON_GOLEM_REPAIR, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.getOwner() != null && player.getUUID().equals(this.getOwner().getUUID())) {
                serverPlayer.openMenu((MenuProvider)this, buf -> buf.writeVarInt(this.getId()));
            } else {
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"entity.createmechanicalcompanion.ownership_warning"), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isModuleEquipped(Item item) {
        if (this.itemHandler.getSlots() != 9) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (this.itemHandler.getStackInSlot(i).getItem() != item) continue;
            return true;
        }
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new CustomLeapAtTargetGoal((Mob)this, 0.3f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(8, (Goal)new StrollUnlessMenuOpenGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, arg_0 -> ((CustomWolf)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 5, false, false, target -> target instanceof LivingEntity && this.getOwner() != null && this.wantsToAttack((LivingEntity)target, this.getOwner())));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void tick() {
        super.tick();
        double boosterSpeedIncrease = (Double)ModConfig.COMMON.boosterRocketSpeedIncrease.get();
        if (!this.level().isClientSide) {
            float quantumDriveCooldown;
            if (this.getOwner() == null) {
                this.discard();
            }
            this.checkForDuplicate();
            double defaultHealthValue = 30.0;
            double defaultArmorValue = 0.0;
            if (this.isModuleEquipped(ModItems.REINFORCED_PLATES.get())) {
                double reinforcedPlatesHealthIncrease = ((Integer)ModConfig.COMMON.reinforcedPlatesHealthIncrease.get()).intValue();
                int reinforcedArmorValue = (Integer)ModConfig.COMMON.reinforcedPlatesArmorValue.get();
                if (this.getAttribute(Attributes.MAX_HEALTH).getBaseValue() != defaultHealthValue + reinforcedPlatesHealthIncrease) {
                    this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(defaultHealthValue + reinforcedPlatesHealthIncrease);
                    this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)ModConfig.COMMON.reinforcedPlatesKnockBackResistance.get()).doubleValue());
                }
                if (this.getAttribute(Attributes.ARMOR).getBaseValue() != (double)reinforcedArmorValue) {
                    this.getAttribute(Attributes.ARMOR).setBaseValue((double)reinforcedArmorValue);
                }
            } else if (this.isModuleEquipped(ModItems.NETHERITE_PLATES.get())) {
                double netheritePlatesHealthIncrease = ((Integer)ModConfig.COMMON.netheritePlatesHealthIncrease.get()).intValue();
                int netheriteArmorValue = (Integer)ModConfig.COMMON.netheritePlatesArmorValue.get();
                if (this.getAttribute(Attributes.MAX_HEALTH).getBaseValue() != defaultHealthValue + netheritePlatesHealthIncrease) {
                    this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(defaultHealthValue + netheritePlatesHealthIncrease);
                    this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)ModConfig.COMMON.netheritePlatesKnockBackResistance.get()).doubleValue());
                }
                if (this.getAttribute(Attributes.ARMOR).getBaseValue() != (double)netheriteArmorValue) {
                    this.getAttribute(Attributes.ARMOR).setBaseValue((double)netheriteArmorValue);
                }
            } else {
                if (this.getAttribute(Attributes.MAX_HEALTH).getBaseValue() != defaultHealthValue) {
                    this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(defaultHealthValue);
                    this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.0);
                    if (this.getHealth() > this.getMaxHealth()) {
                        this.setHealth(this.getMaxHealth());
                    }
                }
                if (this.getAttribute(Attributes.ARMOR).getBaseValue() != defaultArmorValue) {
                    this.getAttribute(Attributes.ARMOR).setBaseValue(defaultArmorValue);
                }
            }
            if (this.isModuleEquipped(ModItems.REGENERATIVE_CASING.get()) && this.getHealth() < this.getMaxHealth()) {
                this.heal(((Double)ModConfig.COMMON.regenerativeCasingHealAmount.get()).floatValue());
            }
            if (this.isModuleEquipped(ModItems.MOUNTED_LIGHT.get())) {
                BlockPos torchPosition = new BlockPos(this.getBlockX(), this.getBlockY() + 1, this.getBlockZ());
                if (torchPosition != this.previousLightPos) {
                    this.removePreviousLightBlock();
                    if (this.level().getBlockState(torchPosition).isAir() && this.isAlive()) {
                        this.level().setBlockAndUpdate(torchPosition, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15)));
                        this.previousLightPos = torchPosition;
                    }
                }
            } else {
                this.removePreviousLightBlock();
            }
            float mountedCrossbowCooldown = ((Integer)ModConfig.COMMON.mountedCrossbowCooldown.get()).intValue();
            if (this.isModuleEquipped(ModItems.MOUNTED_CROSSBOW.get()) && this.getTarget() != null && this.mountedCrossbowTick >= mountedCrossbowCooldown) {
                this.mountedCrossbowTick = 0.0f;
                TargetedArrowEntity arrow = new TargetedArrowEntity(this.level(), (LivingEntity)this, this.getTarget());
                arrow.setBaseDamage(4.0);
                Vec3 direction = this.getTarget().getEyePosition().subtract(this.getEyePosition());
                direction = direction.normalize();
                arrow.setPos(this.getX(), this.getEyeY() + 0.5, this.getZ());
                arrow.shoot(direction.x, direction.y, direction.z, 1.6f, 0.0f);
                float pitch = 0.8f + this.random.nextFloat() * 0.4f;
                this.level().playSound((Entity)this, this.blockPosition(), ModSounds.MOUNTED_CROSSBOW_SOUND.get(), SoundSource.HOSTILE, 0.15f, pitch);
                this.level().addFreshEntity((Entity)arrow);
            } else if (this.mountedCrossbowTick < mountedCrossbowCooldown) {
                this.mountedCrossbowTick += 1.0f;
            }
            AttributeInstance movementAttribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
            float boosterCooldown = ((Integer)ModConfig.COMMON.boosterRocketCooldown.get()).intValue();
            if (this.isModuleEquipped(ModItems.BOOSTER_ROCKET.get()) && this.getTarget() != null && this.boosterTimer >= boosterCooldown) {
                if (movementAttribute.getBaseValue() == 0.35) {
                    movementAttribute.setBaseValue(0.35 + boosterSpeedIncrease);
                    this.boosterTimer = 0.0f;
                }
            } else {
                float boosterDuration = ((Integer)ModConfig.COMMON.boosterRocketDuration.get()).intValue();
                if (this.boosterTimer >= boosterDuration && movementAttribute.getBaseValue() != 0.35) {
                    movementAttribute.setBaseValue(0.35);
                }
            }
            if (this.boosterTimer < boosterCooldown) {
                this.boosterTimer += 1.0f;
            }
            if (this.quantumDriveTimer >= (quantumDriveCooldown = (float)((Integer)ModConfig.COMMON.quantumDriveCooldown.get()).intValue()) && this.getTarget() != null && this.isModuleEquipped(ModItems.QUANTUM_DRIVE.get())) {
                LivingEntity target = this.getTarget();
                Vec3 targetPosition = target.position();
                int teleportX = (int)(targetPosition.x + (this.random.nextDouble() - 0.5) * 2.0);
                int teleportY = (int)targetPosition.y;
                int teleportZ = (int)(targetPosition.z + (this.random.nextDouble() - 0.5) * 2.0);
                if (this.level().isEmptyBlock(new BlockPos(teleportX, teleportY, teleportZ))) {
                    this.teleportTo(teleportX, teleportY, teleportZ);
                    this.level().playSound(null, this.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                this.quantumDriveTimer = 0.0f;
            } else if (this.quantumDriveTimer < quantumDriveCooldown) {
                this.quantumDriveTimer += 1.0f;
            }
            float mobRadarCooldown = ((Integer)ModConfig.COMMON.mobRadarCooldown.get()).intValue();
            if (this.mobRadarTimer >= mobRadarCooldown && this.isModuleEquipped(ModItems.MOB_RADAR.get())) {
                this.applyGlowingToHostileMobs();
                this.mobRadarTimer = 0.0f;
            } else if (this.mobRadarTimer < mobRadarCooldown) {
                this.mobRadarTimer += 1.0f;
            }
            this.syncItemHandler();
        } else {
            if (this.isModuleEquipped(ModItems.MOUNTED_LIGHT.get())) {
                this.spawnMountedTorchParticles();
            }
            if (this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue() == 0.35 + boosterSpeedIncrease) {
                this.spawnRocketBoostParticles();
            }
            float quantumDriveParticleCooldown = 30.0f;
            if (this.isModuleEquipped(ModItems.QUANTUM_DRIVE.get()) && this.quantumDriveParticleTimer >= quantumDriveParticleCooldown) {
                this.spawnQuantumDriveParticles();
                this.quantumDriveParticleTimer = 0.0f;
            } else {
                this.quantumDriveParticleTimer += 1.0f;
            }
        }
    }

    private void applyGlowingToHostileMobs() {
        float radarRadius = ((Integer)ModConfig.COMMON.mobRadarRange.get()).intValue();
        List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)radarRadius), entity -> {
            Mob mob;
            return entity instanceof Mob && (mob = (Mob)entity).getType().getCategory() == MobCategory.MONSTER;
        });
        for (Entity entity2 : nearbyEntities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            int mobRadarPingDuration = 60;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, mobRadarPingDuration, 0, false, false));
        }
    }

    public boolean canChangeDimensions(Level level, Level level1) {
        return false;
    }

    private void checkForDuplicate() {
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Player) {
            CompoundTag compoundTag;
            Player player = (Player)livingEntity;
            ICuriosItemHandler curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null);
            if (curiosInventory == null) {
                this.discard();
                return;
            }
            Optional item = curiosInventory.findCurio("head", 0);
            if (item.isEmpty()) {
                this.discard();
                return;
            }
            ItemStack stack = ((SlotResult)item.get()).stack();
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (customData != null && (compoundTag = customData.copyTag()).contains("WolfUUID") && !this.getUUID().equals(compoundTag.getUUID("WolfUUID"))) {
                this.discard();
            }
        }
    }

    private void spawnQuantumDriveParticles() {
        double offsetX = (this.random.nextDouble() - 0.5) * 0.6;
        double offsetY = this.random.nextDouble() * 0.4 + 0.8;
        double offsetZ = (this.random.nextDouble() - 0.5) * 0.6;
        double x = this.getX() + offsetX;
        double y = this.getY() + offsetY;
        double z = this.getZ() + offsetZ;
        this.level().addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x, y, z, 0.0, 0.01, 0.0);
    }

    private void removePreviousLightBlock() {
        if (this.previousLightPos == null) {
            return;
        }
        this.level().setBlock(this.previousLightPos, Blocks.AIR.defaultBlockState(), 3);
        this.previousLightPos = null;
    }

    public static void removeLightBlocksAround(Entity entity, int radius) {
        Level level = entity.level();
        BlockPos center = entity.blockPosition();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = center.offset(dx, dy, dz);
                    BlockState state = level.getBlockState(pos);
                    if (!state.is(Blocks.LIGHT)) continue;
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
    }

    private void spawnRocketBoostParticles() {
        float boosterAnimationCooldown = 3.0f;
        if (this.boosterAnimationTick >= boosterAnimationCooldown) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.05, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.05, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.05, 0.0);
        } else {
            this.boosterAnimationTick += 1.0f;
        }
    }

    private void spawnMountedTorchParticles() {
        float mountedTorchParticleDelayInTicks = 30.0f;
        if (this.currentTorchTick >= mountedTorchParticleDelayInTicks && this.level().isClientSide) {
            double offsetX = (this.random.nextDouble() - 0.5) * 0.6;
            double offsetY = this.random.nextDouble() * 0.4 + 1.0;
            double offsetZ = (this.random.nextDouble() - 0.5) * 0.6;
            double x = this.getX() + offsetX;
            double y = this.getY() + offsetY;
            double z = this.getZ() + offsetZ;
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.05, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.05, 0.0);
            this.currentTorchTick = 0.0f;
        } else if (this.currentTorchTick < mountedTorchParticleDelayInTicks) {
            this.currentTorchTick += 1.0f;
        }
    }

    public boolean doHurtTarget(Entity pEntity) {
        if (this.isModuleEquipped(ModItems.SMELTING_FANGS.get())) {
            pEntity.setRemainingFireTicks((Integer)ModConfig.COMMON.smeltingFangsFireDuration.get() * 20);
        }
        float pitch = 0.8f + this.random.nextFloat() * 0.4f;
        this.level().playSound((Entity)this, this.blockPosition(), ModSounds.BITE_SOUND.get(), SoundSource.NEUTRAL, 0.6f, pitch);
        return pEntity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttributeValue(Attributes.ATTACK_DAMAGE)));
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isModuleEquipped(ModItems.TESLA_TAIL.get())) {
            if (pSource.getEntity() != null && pSource.getEntity() != this) {
                pSource.getEntity().hurt(pSource.getEntity().damageSources().mobAttack((LivingEntity)this), ((Double)ModConfig.COMMON.teslaTailDamage.get()).floatValue());
                pSource.getEntity().invulnerableTime = 0;
            }
            this.spawnTeslaTailParticles();
        }
        return super.hurt(pSource, pAmount);
    }

    private void spawnTeslaTailParticles() {
        if (!this.level().isClientSide) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getRandomX(1.5), this.getRandomY(), this.getRandomZ(1.5), 0.0, 0.2, 0.0);
        }
    }

    public boolean fireImmune() {
        return this.isModuleEquipped(ModItems.NETHERITE_PLATES.get()) || this.isModuleEquipped(ModItems.SMELTING_FANGS.get());
    }

    public int getArmorValue() {
        if (this.isModuleEquipped(ModItems.REINFORCED_PLATES.get())) {
            return (Integer)ModConfig.COMMON.reinforcedPlatesArmorValue.get();
        }
        if (this.isModuleEquipped(ModItems.NETHERITE_PLATES.get())) {
            return (Integer)ModConfig.COMMON.netheritePlatesArmorValue.get();
        }
        return super.getArmorValue();
    }

    @NotNull
    public Component getDisplayName() {
        return super.getDisplayName();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ITEM_HANDLER_DATA, (Object)new CompoundTag());
    }

    private void syncItemHandler() {
        if (!this.level().isClientSide) {
            CompoundTag tag = this.itemHandler.serializeNBT((HolderLookup.Provider)this.registryAccess());
            this.entityData.set(ITEM_HANDLER_DATA, (Object)tag);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(ITEM_HANDLER_DATA)) {
            CompoundTag tag = (CompoundTag)this.entityData.get(ITEM_HANDLER_DATA);
            this.itemHandler.deserializeNBT((HolderLookup.Provider)this.registryAccess(), tag);
        }
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DAMAGE;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.IRON_GOLEM_DAMAGE;
    }

    public void die(DamageSource pCause) {
        CustomWolf.removeLightBlocksAround((Entity)this, 5);
    }
}

