/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.myr.createmechanicalcompanion.client.CustomWolfModel;
import net.myr.createmechanicalcompanion.client.ModModelLayers;
import net.myr.createmechanicalcompanion.entity.CustomWolf;
import org.jetbrains.annotations.NotNull;

public class WolfRenderer
extends MobRenderer<CustomWolf, CustomWolfModel> {
    private static final ResourceLocation WOLF_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createmechanicalcompanion", (String)"textures/entity/wolf.png");
    private static final ResourceLocation DENNIS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createmechanicalcompanion", (String)"textures/entity/dennis.png");
    private static final ResourceLocation COOLER_DENNIS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createmechanicalcompanion", (String)"textures/entity/cooler_dennis.png");

    public WolfRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CustomWolfModel(context.bakeLayer(ModModelLayers.CUSTOM_WOLF)), 0.5f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CustomWolf entity) {
        if (entity.getCustomName() == null) {
            return WOLF_TEXTURE;
        }
        return switch (entity.getCustomName().getString()) {
            case "Dennis" -> DENNIS_TEXTURE;
            case "The Cooler Dennis" -> COOLER_DENNIS_TEXTURE;
            default -> WOLF_TEXTURE;
        };
    }

    public void render(CustomWolf pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

