/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.mixin;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.JOrbisAudioStream;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.sound.OggAudioStreamExtended;

@Mixin(value={JOrbisAudioStream.class})
public abstract class OggAudioStreamMixin
implements OggAudioStreamExtended {
    private static final Random RANDOM = new Random();
    @Shadow
    @Final
    private AudioFormat audioFormat;
    @Shadow
    @Final
    private InputStream input;

    @Override
    public boolean setPositionRandomly(long length, ResourceLocation id) throws IOException {
        if (length == 0L) {
            return true;
        }
        int skipped = RANDOM.nextInt((int)(length - length / 4L));
        this.input.skipNBytes(skipped);
        int searched = 0;
        int errors = 0;
        while (true) {
            try {
                for (int i = 0; i < 2; ++i) {
                    ++searched;
                    if (((JOrbisAudioStream)this).readChunk(x -> {})) continue;
                    AmbientSounds.LOGGER.error("Possibly reached end of file {}/{}", (Object)skipped, (Object)length);
                    return false;
                }
            }
            catch (IOException | IllegalStateException e) {
                try {
                    ++errors;
                    this.readToBuffer();
                    continue;
                }
                catch (IOException e2) {
                    AmbientSounds.LOGGER.error("Failed to play sound with offset {}/{}", (Object)skipped, (Object)length);
                    AmbientSounds.LOGGER.error((Object)e2);
                    return false;
                }
            }
            if (searched >= 6 && (errors >= 1 || searched >= 512)) break;
        }
        return true;
    }

    @Shadow
    private Packet readPacket() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Shadow
    private Page readPage() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Shadow
    private boolean readToBuffer() throws IOException {
        throw new UnsupportedOperationException();
    }
}

