/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class SlimeBootsTickEventProcedure {
    public static void execute(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.isShiftKeyDown()) {
            entity.getPersistentData().putDouble("slimeFalling", 0.0);
        } else {
            entity.fallDistance = 0.0f;
            if (!entity.onGround()) {
                entity.getPersistentData().putDouble("slimeFalling", entity.getDeltaMovement().y() * -1.0);
            }
            if (entity.onGround() && !entity.isShiftKeyDown() && entity.getPersistentData().getDouble("slimeFalling") > 0.25) {
                entity.setDeltaMovement(new Vec3(entity.getDeltaMovement().x(), entity.getPersistentData().getDouble("slimeFalling") * 0.75, entity.getDeltaMovement().z()));
                if (world instanceof Level) {
                    Level _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.slime.jump")), SoundSource.NEUTRAL, 0.2f, 4.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.slime.jump")), SoundSource.NEUTRAL, 0.2f, 4.0f, false);
                    }
                }
                if (entity.isSprinting()) {
                    entity.setDeltaMovement(new Vec3(entity.getDeltaMovement().x() + entity.getLookAngle().x * entity.getPersistentData().getDouble("slimeFalling") * 0.75, entity.getDeltaMovement().y(), entity.getDeltaMovement().z() + entity.getLookAngle().z * entity.getPersistentData().getDouble("slimeFalling") * 0.75));
                }
            }
        }
    }
}

