/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter.recipe;

import com.oierbravo.createsifter.content.contraptions.components.meshes.AbstractAdvancedMesh;
import com.oierbravo.createsifter.content.contraptions.components.meshes.MeshUtils;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeInput;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeManager;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeSerializer;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.requirements.AdvancedSifterRecipeRequirement;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.requirements.WaterloggedRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipeParams;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SiftingRecipe
extends AbstractMechanicalRecipe<RecipeInput, SiftingRecipeParams> {
    private final Ingredient input;
    private final NonNullList<ProcessingOutput> results;
    private final ItemStack mesh;
    private final int processingTime;
    private final boolean waterlogged;
    private final boolean advancedSifter;

    public SiftingRecipe(SiftingRecipeParams params) {
        super((AbstractMechanicalRecipeParams)params);
        this.input = params.input;
        this.results = params.results;
        this.mesh = params.mesh;
        this.processingTime = params.processingTime;
        this.waterlogged = params.waterlogged;
        this.advancedSifter = params.advancedSifter;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ArrayList<IRecipeRequirement> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return this.getInput().test(recipeInput.getItem(0)) && this.getMesh().is(recipeInput.getItem(1).getItem());
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.getResultItem(provider);
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.getRollableResults().isEmpty() ? ItemStack.EMPTY : this.getRollableResults().getFirst().getStack();
    }

    public List<ProcessingOutput> getRollableResults() {
        return this.results;
    }

    public List<ItemStack> getRollableResultsAsItemStacks() {
        return this.getRollableResults().stream().map(ProcessingOutput::getStack).collect(Collectors.toList());
    }

    public List<ItemStack> rollResults(RandomSource source) {
        return this.rollResults(this.getRollableResults(), source);
    }

    public List<ItemStack> rollResults(List<ProcessingOutput> rollableResults, RandomSource source) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < rollableResults.size(); ++i) {
            ProcessingOutput output = rollableResults.get(i);
            ItemStack stack = output.rollOutput(source);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public NonNullList<ProcessingOutput> getResults() {
        return this.results;
    }

    public ItemStack getMesh() {
        return this.mesh;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    public boolean isNotWaterlogged() {
        return !this.isWaterlogged();
    }

    public RecipeSerializer<?> getSerializer() {
        return SiftingRecipeSerializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean usesAdvancedMesh() {
        return this.getMesh().getItem() instanceof AbstractAdvancedMesh;
    }

    public static boolean canHandSift(Level level, SiftingRecipeInput input, boolean waterlogged) {
        if (MeshUtils.isAdvancedMesh(input.mesh())) {
            return false;
        }
        return SiftingRecipeManager.getRecipeForHandSifting(level, input, waterlogged).isPresent();
    }

    public static List<ItemStack> applyHandSifting(SiftingRecipe recipe, RandomSource source) {
        return recipe.rollResults(source);
    }

    public static List<ItemStack> applyHandSifting(Level world, Vec3 position, SiftingRecipe recipe, RandomSource source) {
        return recipe.rollResults(source);
    }

    public boolean notRequiresAdvancedMesh() {
        return !this.usesAdvancedMesh();
    }

    public List<IRecipeRequirement> getJeiRecipeRequirements() {
        ArrayList<Record> extraRequirements = new ArrayList<Record>();
        if (this.requiresAdvancedSifter().booleanValue()) {
            extraRequirements.add(new AdvancedSifterRecipeRequirement(true));
        }
        if (this.isWaterlogged()) {
            extraRequirements.add(new WaterloggedRecipeRequirement(true));
        }
        return Stream.concat(extraRequirements.stream(), super.getJeiRecipeRequirements().stream()).toList();
    }

    public boolean advancedSifter() {
        return this.advancedSifter;
    }

    public Boolean requiresAdvancedSifter() {
        if (this.usesAdvancedMesh()) {
            return true;
        }
        return this.advancedSifter;
    }

    public ArrayList<IRecipeRequirement> getRecipeRequirementsToCheck() {
        ArrayList<IRecipeRequirement> recipeRequirementArrayList = this.getRecipeRequirements();
        recipeRequirementArrayList.add(new WaterloggedRecipeRequirement(this.waterlogged));
        recipeRequirementArrayList.add(new AdvancedSifterRecipeRequirement(this.advancedSifter));
        return recipeRequirementArrayList;
    }

    public static class SiftingRecipeParams
    extends AbstractMechanicalRecipeParams {
        protected Ingredient input = Ingredient.EMPTY;
        protected NonNullList<ProcessingOutput> results = NonNullList.create();
        protected ItemStack mesh = ItemStack.EMPTY;
        protected int processingTime = 500;
        protected boolean waterlogged = false;
        protected boolean advancedSifter = false;

        protected SiftingRecipeParams() {
        }
    }

    public static class Type
    implements RecipeType<SiftingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final RecipeType<SiftingRecipe> RECIPE_TYPE = new Type();
        public static final String ID = "sifting";

        private Type() {
        }
    }
}

