/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter;

import com.oierbravo.createsifter.content.contraptions.components.meshes.IMesh;
import com.oierbravo.createsifter.content.contraptions.components.sifter.AbstractSifterBlockEntity;
import com.oierbravo.createsifter.register.ModShapes;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class AbstractSifterBlock<BE extends BlockEntity>
extends KineticBlock
implements IBE<BE>,
ICogWheel,
SimpleWaterloggedBlock {
    public AbstractSifterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static InteractionResultHolder<ItemStack> tryToInsertMesh(BlockState state, Level world, BlockPos pos, ItemStack stack, boolean simulate) {
        if (!state.hasBlockEntity()) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof AbstractSifterBlockEntity)) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        AbstractSifterBlockEntity sifterBE = (AbstractSifterBlockEntity)be;
        if (!sifterBE.tryToInsertMesh(stack, null, simulate)) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        return InteractionResultHolder.success((Object)ItemStack.EMPTY);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ModShapes.SIFTER;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.DOWN;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() instanceof IMesh) {
            this.withBlockEntityDo((BlockGetter)level, pos, sifter -> ((AbstractSifterBlockEntity)((Object)sifter)).tryToInsertMesh(stack, player, false));
            return ItemInteractionResult.SUCCESS;
        }
        if (!stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            AbstractSifterBlockEntity sifter = (AbstractSifterBlockEntity)((Object)be);
            boolean emptyOutput = true;
            ItemStackHandler inv = sifter.getOutputInventory();
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.isEmpty()) {
                    emptyOutput = false;
                }
                player.getInventory().placeItemBackInInventory(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.EMPTY);
            }
            boolean emptyInput = true;
            if (emptyOutput) {
                inv = sifter.getInputInventory();
                ItemStack inputStack = inv.getStackInSlot(0);
                inv.setStackInSlot(0, ItemStack.EMPTY);
                if (!inputStack.isEmpty()) {
                    emptyInput = false;
                    player.getInventory().placeItemBackInInventory(inputStack);
                }
            }
            if (emptyInput && stack.isEmpty() && sifter.hasMesh() && player.isShiftKeyDown()) {
                sifter.removeMesh(player);
            }
            sifter.setChanged();
            sifter.sendData();
        });
        return ItemInteractionResult.SUCCESS;
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
        if (entityIn.level().isClientSide) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        if (!entityIn.isAlive()) {
            return;
        }
        AbstractSifterBlockEntity sifter = null;
        for (BlockPos pos : Iterate.hereAndBelow((BlockPos)entityIn.blockPosition())) {
            if (sifter != null) continue;
            sifter = (AbstractSifterBlockEntity)this.getBlockEntity(worldIn, pos);
        }
        if (sifter == null) {
            return;
        }
        IItemHandler capability = (IItemHandler)sifter.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, sifter.getBlockPos(), null);
        if (capability == null) {
            return;
        }
        ItemStack remainder = capability.insertItem(0, itemEntity.getItem(), false);
        if (remainder.isEmpty()) {
            itemEntity.discard();
        }
        if (remainder.getCount() < itemEntity.getItem().getCount()) {
            itemEntity.setItem(remainder);
        }
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && state.getBlock() != newState.getBlock()) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                AbstractSifterBlockEntity sifter = (AbstractSifterBlockEntity)((Object)be);
                ItemHelper.dropContents((Level)worldIn, (BlockPos)pos, (IItemHandler)sifter.getInputInventory());
                ItemHelper.dropContents((Level)worldIn, (BlockPos)pos, (IItemHandler)sifter.getMeshInventory());
                ItemHelper.dropContents((Level)worldIn, (BlockPos)pos, (IItemHandler)sifter.getOutputInventory());
            });
            worldIn.removeBlockEntity(pos);
        }
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState FluidState2 = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }
}

