/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.experience;

import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class ExperienceHatchBehaviour
extends FilteringBehaviour {
    public static final BehaviourType<ExperienceHatchBehaviour> TYPE = new BehaviourType();
    public static final int POINTS_PER_SCROLL = 10;

    public ExperienceHatchBehaviour(SmartBlockEntity blockEntity, ValueBoxTransform slot) {
        super(blockEntity, slot);
        this.forFluids();
        this.count = 0;
    }

    public FluidStack getFluidToDrain() {
        int unit;
        FluidEntry<BaseFlowingFluid.Source> fluid = this.filter.fluid(this.getWorld()).getFluidHolder();
        if (Fluids.EMPTY.isSame((Fluid)fluid.value())) {
            unit = 1;
            fluid = CEIFluids.EXPERIENCE;
        } else {
            unit = ExperienceHelper.getExperienceFluidUnit((Holder<Fluid>)fluid);
        }
        if (unit == 0) {
            return FluidStack.EMPTY;
        }
        int amount = this.count * 10;
        amount = this.count == 0 ? Integer.MAX_VALUE : amount * unit;
        return new FluidStack(fluid, amount);
    }

    public FluidStack getFluidToFill(int available) {
        int unit;
        if (available == 0) {
            return FluidStack.EMPTY;
        }
        FluidEntry<BaseFlowingFluid.Source> fluid = this.filter.fluid(this.getWorld()).getFluidHolder();
        if (Fluids.EMPTY.isSame((Fluid)fluid.value())) {
            unit = 1;
            fluid = CEIFluids.EXPERIENCE;
        } else {
            unit = ExperienceHelper.getExperienceFluidUnit((Holder<Fluid>)fluid);
        }
        if (unit == 0) {
            return FluidStack.EMPTY;
        }
        int amount = this.count * 10;
        amount = this.count == 0 ? available : Math.min(available, amount * unit);
        return new FluidStack(fluid, amount);
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        nbt.put("Filter", this.getFilter().saveOptional(registries));
        nbt.putInt("Scroll", this.count);
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        this.filter = FilterItemStack.of((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("Filter"));
        this.count = nbt.getInt("Scroll");
    }

    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals((Object)settings)) {
            return;
        }
        this.count = settings.value();
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
        this.playFeedbackSound((BlockEntityBehaviour)this);
    }

    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(0, this.count);
    }

    public boolean isCountVisible() {
        return true;
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        return new ValueSettingsBoard((Component)CEILang.translate("gui.experience_hatch.exchange", new Object[0]).component(), 100, 10, List.of(CEILang.translate("gui.experience_hatch.points", new Object[0]).component()), new ValueSettingsFormatter(this::formatValue));
    }

    public MutableComponent formatValue(ValueSettingsBehaviour.ValueSettings value) {
        int count = value.value();
        if (count == 0) {
            return CEILang.translate("gui.experience_hatch.all", new Object[0]).component();
        }
        return Component.literal((String)String.valueOf(count * 10));
    }

    public MutableComponent getCountLabelForValueBox() {
        if (this.count == 0) {
            return Component.literal((String)"*");
        }
        return Component.literal((String)String.valueOf(this.count * 10));
    }

    public boolean setFilter(ItemStack stack) {
        FluidStack fluid;
        FilterItemStack filter = FilterItemStack.of((ItemStack)stack.copy());
        if (!filter.isEmpty() && !(fluid = filter.fluid(this.getWorld())).is(CEIFluids.EXPERIENCE) && fluid.getFluidHolder().getData(CEIDataMaps.FLUID_UNIT_EXPERIENCE) == null) {
            return false;
        }
        this.filter = filter;
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
        return true;
    }

    public String getClipboardKey() {
        return "ExperienceHatch";
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }
}

