/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.ClassPatchInstance;
import org.sinytra.adapter.patch.InterfacePatchInstance;
import org.sinytra.adapter.patch.MethodContextImpl;
import org.sinytra.adapter.patch.PatchContextImpl;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.transformer.operation.unit.ModifyTargetClasses;
import org.sinytra.adapter.patch.util.MethodTransformBuilderImpl;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract sealed class PatchInstance
implements Patch
permits ClassPatchInstance, InterfacePatchInstance {
    public static final Collection<String> KNOWN_MIXIN_TYPES = Set.of("Lorg/spongepowered/asm/mixin/injection/Inject;", "Lorg/spongepowered/asm/mixin/injection/Redirect;", "Lorg/spongepowered/asm/mixin/injection/ModifyArg;", "Lorg/spongepowered/asm/mixin/injection/ModifyArgs;", "Lorg/spongepowered/asm/mixin/injection/ModifyVariable;", "Lorg/spongepowered/asm/mixin/injection/ModifyConstant;", "Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;", "Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;", "Lcom/llamalad7/mixinextras/injector/WrapWithCondition;", "Lcom/llamalad7/mixinextras/injector/ModifyReturnValue;");
    public static final Marker MIXINPATCH = MarkerFactory.getMarker((String)"MIXINPATCH");
    protected final List<String> targetClasses;
    protected final List<String> targetAnnotations;
    @Nullable
    protected final Predicate<AnnotationHandle> targetAnnotationValues;
    protected final List<ClassTransform> classTransforms;
    protected final List<MethodTransform> transforms;

    protected PatchInstance(List<String> targetClasses, List<String> targetAnnotations, List<MethodTransform> transforms) {
        this(targetClasses, targetAnnotations, map -> true, List.of(), transforms);
    }

    protected PatchInstance(List<String> targetClasses, List<String> targetAnnotations, Predicate<AnnotationHandle> targetAnnotationValues, List<ClassTransform> classTransforms, List<MethodTransform> transforms) {
        this.targetClasses = targetClasses;
        this.targetAnnotations = targetAnnotations;
        this.targetAnnotationValues = targetAnnotationValues;
        this.classTransforms = classTransforms;
        this.transforms = transforms;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, PatchEnvironment environment) {
        Patch.Result result = Patch.Result.PASS;
        ClassTarget classTarget = this.checkClassTarget(classNode);
        if (classTarget != null) {
            PatchContextImpl context = new PatchContextImpl(classNode, classTarget.targetTypes(), environment);
            AnnotationValueHandle<?> classAnnotation = classTarget.handle();
            for (ClassTransform classTransform : this.classTransforms) {
                result = result.or(classTransform.apply(classNode, classTarget.handle(), context));
            }
            block1: for (MethodNode method : classNode.methods) {
                MethodContext methodContext = this.checkMethodTarget(classTarget.ann(), classAnnotation, classNode, method, environment, classTarget.targetTypes(), context);
                if (methodContext == null) continue;
                if (!this.transforms.isEmpty()) {
                    environment.auditTrail().prepareMethod(methodContext);
                }
                for (MethodTransform transform : this.transforms) {
                    Collection<String> accepted = transform.getAcceptedAnnotations();
                    if (!accepted.isEmpty() && !accepted.contains(methodContext.methodAnnotation().getDesc())) continue;
                    Patch.Result txResult = transform.apply(classNode, method, methodContext, context);
                    result = result.or(txResult);
                    if (txResult != Patch.Result.APPLY || environment.auditTrail().getMatch(methodContext) != PatchAuditTrail.Match.FULL) continue;
                    continue block1;
                }
            }
            context.run();
        }
        return result;
    }

    private ClassTarget checkClassTarget(ClassNode classNode) {
        if (classNode.invisibleAnnotations != null) {
            for (AnnotationNode annotation : classNode.invisibleAnnotations) {
                if (!annotation.desc.equals("Lorg/spongepowered/asm/mixin/Mixin;")) continue;
                AnnotationHandle ann = new AnnotationHandle(annotation);
                return PatchInstance.findAnnotationValue(annotation.values, "value").map(types -> {
                    for (Type targetType : (List)types.get()) {
                        if (!this.targetClasses.isEmpty() && !this.targetClasses.contains(targetType.getInternalName())) continue;
                        return new ClassTarget(ann, (AnnotationValueHandle<?>)types, (List)types.get());
                    }
                    return null;
                }).or(() -> PatchInstance.findAnnotationValue(annotation.values, "targets").map(types -> {
                    for (String targetType : (List)types.get()) {
                        if (!this.targetClasses.isEmpty() && !this.targetClasses.contains(targetType)) continue;
                        return new ClassTarget(ann, (AnnotationValueHandle<?>)types, ((List)types.get()).stream().map(Type::getObjectType).toList());
                    }
                    return null;
                })).orElse(null);
            }
        }
        return this.targetClasses.isEmpty() ? new ClassTarget(null, null, List.of()) : null;
    }

    @Nullable
    private MethodContext checkMethodTarget(@Nullable AnnotationHandle rawClassAnnotation, @Nullable AnnotationValueHandle<?> classAnnotation, ClassNode owner, MethodNode method, PatchEnvironment remaper, List<Type> targetTypes, PatchContext context) {
        if (method.visibleAnnotations != null) {
            for (AnnotationNode annotation : method.visibleAnnotations) {
                AnnotationHandle annotationHandle;
                if (!this.targetAnnotations.isEmpty() && !this.targetAnnotations.contains(annotation.desc)) continue;
                MethodContextImpl.Builder builder = MethodContextImpl.builder();
                if (rawClassAnnotation != null && classAnnotation != null) {
                    builder.classNode(owner);
                    builder.rawClassAnnotation(rawClassAnnotation);
                    builder.classAnnotation(classAnnotation);
                    builder.targetTypes(targetTypes);
                }
                if (!this.checkAnnotation(owner.name, method, annotationHandle = new AnnotationHandle(annotation), remaper, builder) || this.targetAnnotationValues != null && !this.targetAnnotationValues.test(annotationHandle)) continue;
                return builder.build(context);
            }
        }
        return null;
    }

    protected abstract boolean checkAnnotation(String var1, MethodNode var2, AnnotationHandle var3, PatchEnvironment var4, MethodContextImpl.Builder var5);

    public static <T> Optional<AnnotationValueHandle<T>> findAnnotationValue(@Nullable List<Object> values, String key) {
        if (values != null) {
            for (int i = 0; i < values.size(); i += 2) {
                String atKey = (String)values.get(i);
                if (!atKey.equals(key)) continue;
                int index = i + 1;
                return Optional.of(new AnnotationValueHandle(values, index, key));
            }
        }
        return Optional.empty();
    }

    private record ClassTarget(AnnotationHandle ann, @Nullable AnnotationValueHandle<?> handle, List<Type> targetTypes) {
    }

    protected static abstract class BaseBuilder<T extends Patch.Builder<T>>
    extends MethodTransformBuilderImpl<T>
    implements Patch.Builder<T> {
        protected final Set<String> targetClasses = new HashSet<String>();
        protected final Set<String> targetAnnotations = new HashSet<String>();
        protected Predicate<AnnotationHandle> targetAnnotationValues;
        protected final List<ClassTransform> classTransforms = new ArrayList<ClassTransform>();

        protected BaseBuilder() {
        }

        @Override
        public T targetClass(String ... targets) {
            this.targetClasses.addAll(List.of(targets));
            return this.coerce();
        }

        @Override
        public T targetMixinType(String ... annotationDescs) {
            this.targetAnnotations.addAll(List.of(annotationDescs));
            return this.coerce();
        }

        @Override
        public T targetAnnotationValues(Predicate<AnnotationHandle> values) {
            this.targetAnnotationValues = this.targetAnnotationValues == null ? values : this.targetAnnotationValues.or(values);
            return this.coerce();
        }

        @Override
        public T modifyTargetClasses(Consumer<List<Type>> consumer) {
            return (T)((Patch.Builder)this.transform(new ModifyTargetClasses(consumer)));
        }

        @Override
        public T transform(List<ClassTransform> classTransforms) {
            this.classTransforms.addAll(classTransforms);
            return this.coerce();
        }

        @Override
        public T transform(ClassTransform transformer) {
            this.classTransforms.add(transformer);
            return this.coerce();
        }

        private T coerce() {
            return (T)this;
        }
    }
}

