/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs.neoforge;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigBuilder;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigType;
import net.mehvahdjukaar.modelfix.moonlight_configs.neoforge.ConfigSpecWrapper;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.http.annotation.Experimental;

public class ConfigBuilderImpl
extends ConfigBuilder {
    private final List<ModConfigSpec.ConfigValue<?>> requireGameRestart = new ArrayList();
    private boolean currentGameRestart;
    private ModConfigSpec.ConfigValue<?> currentValue;
    private final List<ValueWrapper<?, ?>> specialValues = new ArrayList();
    private final ModConfigSpec.Builder builder;
    private final Deque<String> cat = new ArrayDeque<String>();

    public static ConfigBuilder create(ResourceLocation name, ConfigType type) {
        return new ConfigBuilderImpl(name, type);
    }

    public ConfigBuilderImpl(ResourceLocation name, ConfigType type) {
        super(name, type);
        this.builder = new ModConfigSpec.Builder();
    }

    @Override
    public String currentCategory() {
        return this.cat.peekFirst();
    }

    @Override
    public ConfigSpecWrapper build() {
        return new ConfigSpecWrapper(this.getName(), this.builder.build(), this.type, this.changeCallback, this.requireGameRestart, this.specialValues);
    }

    @Override
    public ConfigBuilderImpl push(String category) {
        this.builder.push(category);
        this.cat.push(category);
        return this;
    }

    @Override
    public ConfigBuilderImpl pop() {
        this.builder.pop();
        this.cat.pop();
        return this;
    }

    @Override
    public Supplier<Boolean> define(String name, boolean defaultValue) {
        ModConfigSpec.BooleanValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.define(name, defaultValue);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public Supplier<Integer> define(String name, int defaultValue, int min, int max) {
        ModConfigSpec.IntValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineInRange(name, defaultValue, min, max);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public Supplier<Double> define(String name, double defaultValue, double min, double max) {
        ModConfigSpec.DoubleValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineInRange(name, defaultValue, min, max);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    @Experimental
    public Supplier<Float> define(String name, float defaultValue, float min, float max) {
        ModConfigSpec.DoubleValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineInRange(name, (double)defaultValue, (double)min, (double)max);
        this.maybeAddGameRestart();
        ValueWrapper<Float, Double> wrapper = new ValueWrapper<Float, Double>(this, (ModConfigSpec.ConfigValue)value){

            @Override
            Float map(Double value) {
                return Float.valueOf(value.floatValue());
            }
        };
        this.specialValues.add(wrapper);
        return wrapper;
    }

    @Override
    public Supplier<String> define(String name, String defaultValue, Predicate<Object> validator) {
        ModConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.define(name, (Object)defaultValue, validator);
        this.maybeAddGameRestart();
        return value;
    }

    public <T> Supplier<T> define(String name, Supplier<T> defaultValue, Predicate<Object> validator) {
        ModConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.define(name, defaultValue, validator);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public <T extends String> Supplier<List<String>> define(String name, List<? extends T> defaultValue, Predicate<Object> predicate) {
        ModConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineList(name, defaultValue, predicate);
        this.maybeAddGameRestart();
        return () -> (List)value.get();
    }

    @Override
    public <V extends Enum<V>> Supplier<V> define(String name, V defaultValue) {
        ModConfigSpec.EnumValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineEnum(name, defaultValue);
        this.maybeAddGameRestart();
        return value;
    }

    private void maybeAddGameRestart() {
        if (this.currentGameRestart && this.currentValue != null) {
            this.requireGameRestart.add(this.currentValue);
            this.currentGameRestart = false;
            this.currentValue = null;
        }
    }

    @Override
    public ConfigBuilder gameRestart() {
        this.currentGameRestart = true;
        this.maybeAddGameRestart();
        return this;
    }

    @Override
    public ConfigBuilder worldReload() {
        this.builder.worldRestart();
        return this;
    }

    @Override
    public ConfigBuilder comment(String comment) {
        this.builder.comment(comment);
        return super.comment(comment);
    }

    public static abstract class ValueWrapper<T, C>
    implements Supplier<T> {
        private final ModConfigSpec.ConfigValue<C> original;
        private T cachedValue = null;

        ValueWrapper(ModConfigSpec.ConfigValue<C> original) {
            this.original = original;
        }

        abstract T map(C var1);

        public void clearCache() {
            this.cachedValue = null;
        }

        @Override
        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.map(this.original.get());
            }
            return this.cachedValue;
        }
    }
}

