/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.worldgen;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.worldgen.TFMGConfiguredFeatures;
import com.simibubi.create.infrastructure.worldgen.ConfigPlacementFilter;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class TFMGPlacedFeatures {
    public static final ResourceKey<PlacedFeature> OIL_DEPOSIT = TFMGPlacedFeatures.key("oil_deposit");
    public static final ResourceKey<PlacedFeature> OIL_WELL = TFMGPlacedFeatures.key("oil_well");
    public static final ResourceKey<PlacedFeature> LEAD_ORE = TFMGPlacedFeatures.key("lead_ore");
    public static final ResourceKey<PlacedFeature> NICKEL_ORE = TFMGPlacedFeatures.key("nickel_ore");
    public static final ResourceKey<PlacedFeature> LITHIUM_ORE = TFMGPlacedFeatures.key("lithium_ore");
    public static final ResourceKey<PlacedFeature> TFMG_STRIATED_ORES_OVERWORLD = TFMGPlacedFeatures.key("tfmg_striated_ores_overworld");
    public static final ResourceKey<PlacedFeature> TFMG_STRIATED_ORES_NETHER = TFMGPlacedFeatures.key("tfmg_striated_ores_nether");

    private static ResourceKey<PlacedFeature> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)TFMG.asResource(name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> ctx) {
        HolderGetter featureLookup = ctx.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference oilDeposit = featureLookup.getOrThrow(TFMGConfiguredFeatures.OIL_DEPOSIT);
        Holder.Reference oilWell = featureLookup.getOrThrow(TFMGConfiguredFeatures.OIL_WELL);
        Holder.Reference leadOre = featureLookup.getOrThrow(TFMGConfiguredFeatures.LEAD_ORE);
        Holder.Reference nickelOre = featureLookup.getOrThrow(TFMGConfiguredFeatures.NICKEL_ORE);
        Holder.Reference lithiumOre = featureLookup.getOrThrow(TFMGConfiguredFeatures.LITHIUM_ORE);
        Holder.Reference striatedOresOverworld = featureLookup.getOrThrow(TFMGConfiguredFeatures.TFMG_STRIATED_ORES_OVERWORLD);
        Holder.Reference striatedOresNether = featureLookup.getOrThrow(TFMGConfiguredFeatures.TFMG_STRIATED_ORES_NETHER);
        PlacementUtils.register(ctx, OIL_DEPOSIT, (Holder)oilDeposit, TFMGPlacedFeatures.oilPlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)4)));
        PlacementUtils.register(ctx, OIL_WELL, (Holder)oilWell, TFMGPlacedFeatures.oilPlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)500)));
        PlacementUtils.register(ctx, LEAD_ORE, (Holder)leadOre, TFMGPlacedFeatures.placement((PlacementModifier)CountPlacement.of((int)5), -15, 80));
        PlacementUtils.register(ctx, NICKEL_ORE, (Holder)nickelOre, TFMGPlacedFeatures.placement((PlacementModifier)CountPlacement.of((int)5), -63, 20));
        PlacementUtils.register(ctx, LITHIUM_ORE, (Holder)lithiumOre, TFMGPlacedFeatures.placement((PlacementModifier)CountPlacement.of((int)3), -63, -5));
        PlacementUtils.register(ctx, TFMG_STRIATED_ORES_OVERWORLD, (Holder)striatedOresOverworld, TFMGPlacedFeatures.placement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)18), -30, 70));
        PlacementUtils.register(ctx, TFMG_STRIATED_ORES_NETHER, (Holder)striatedOresNether, TFMGPlacedFeatures.placement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)18), 40, 90));
    }

    private static List<PlacementModifier> placement(PlacementModifier frequency, int minHeight, int maxHeight) {
        return List.of(frequency, InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)maxHeight)), ConfigPlacementFilter.INSTANCE);
    }

    private static List<PlacementModifier> oilPlacement(PlacementModifier frequency) {
        return List.of(frequency, InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-64)), ConfigPlacementFilter.INSTANCE);
    }
}

