/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes.jei;

import com.drmangotea.tfmg.content.machinery.misc.winding_machine.SpoolItem;
import com.drmangotea.tfmg.recipes.WindingRecipe;
import com.drmangotea.tfmg.recipes.jei.machines.WindingMachine;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedDeployer;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class WindingCategory
extends CreateRecipeCategory<WindingRecipe> {
    private final WindingMachine windingMachine = new WindingMachine();

    public WindingCategory(CreateRecipeCategory.Info<WindingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WindingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 9).setBackground(WindingCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.getIngredients().get(0));
        ItemStack coil = ((Ingredient)recipe.getIngredients().get(1)).getItems()[0];
        coil.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)recipe.getProcessingDuration());
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 30).setBackground(WindingCategory.getRenderedSlot(), -1, -1).addItemStack(coil);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 28).setBackground(WindingCategory.getRenderedSlot(), -1, -1).addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    public void draw(WindingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_ARROW.render(graphics, 85, 32);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 43, 4);
        int coilColor = 0;
        if (((Ingredient)recipe.getIngredients().get(1)).getItems()[0].getItem() instanceof SpoolItem) {
            coilColor = ((Ingredient)recipe.getIngredients().get(1)).getItems()[0].getBarColor();
        }
        this.windingMachine.draw(graphics, 48, 27, coilColor, true);
        graphics.drawString(Minecraft.getInstance().font, recipe.getProcessingDuration() + " Turns", 86.0f, 9.0f, 0x404040, false);
    }

    public static class AssemblyWinding
    extends SequencedAssemblySubCategory {
        private final WindingMachine windingMachine = new WindingMachine();
        private final AnimatedDeployer deployer = new AnimatedDeployer();

        public AssemblyWinding() {
            super(25);
        }

        public void setRecipe(IRecipeLayoutBuilder builder, SequencedRecipe<?> recipe, IFocusGroup focuses, int x) {
            ItemStack coil = ((Ingredient)recipe.getRecipe().getIngredients().get(1)).getItems()[0];
            coil.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)recipe.getRecipe().getProcessingDuration());
            builder.addSlot(RecipeIngredientRole.INPUT, x + 4, 15).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addItemStack(coil);
        }

        public void draw(SequencedRecipe<?> recipe, GuiGraphics graphics, double mouseX, double mouseY, int index) {
            PoseStack ms = graphics.pose();
            int coilColor = 0;
            if (((Ingredient)recipe.getRecipe().getIngredients().get(1)).getItems()[0].getItem() instanceof SpoolItem) {
                coilColor = ((Ingredient)recipe.getRecipe().getIngredients().get(1)).getItems()[0].getBarColor();
            }
            this.windingMachine.offset = index;
            ms.pushPose();
            ms.translate(0.0, 67.0, 0.0);
            ms.scale(0.7f, 0.7f, 0.7f);
            this.windingMachine.draw(graphics, this.getWidth() / 2, 0, coilColor, false);
            ms.popPose();
        }
    }
}

