/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.casting_basin;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.recipes.CastingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CastingBasinBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    int flowTimer = 0;
    public SmartInventory inventory = new SmartInventory(1, (SyncedBlockEntity)this, 1, false);
    public FluidTank tank = new SmartFluidTank(144, this::onFluidChanged);
    public IFluidHandler fluidCapability;
    public IItemHandlerModifiable itemCapability;
    public CastingRecipe recipe = null;
    public int timer = 0;
    private static final Object castingRecipeKey = new Object();
    LerpedFloat fluidLevel = LerpedFloat.linear();

    public CastingBasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = this.tank;
        this.itemCapability = this.inventory;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.CASTING_BASIN.get(), (be, context) -> be.fluidCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.CASTING_BASIN.get(), (be, context) -> be.itemCapability);
    }

    public void tick() {
        super.tick();
        if (this.tank.getSpace() == 0) {
            if (this.recipe == null) {
                this.findRecipe();
            }
            if (this.recipe != null) {
                if (this.recipe.getIngrenient().test(this.tank.getFluid())) {
                    if (this.timer >= this.recipe.getProcessingDuration()) {
                        this.tank.setFluid(FluidStack.EMPTY);
                        this.inventory.setStackInSlot(0, ((ProcessingOutput)this.recipe.getRollableResults().get(0)).rollOutput(this.level.random));
                        this.recipe = null;
                        this.timer = 0;
                    } else {
                        ++this.timer;
                    }
                } else {
                    this.findRecipe();
                }
            } else {
                this.timer = 0;
            }
        }
        if (this.level.isClientSide) {
            if (this.flowTimer > 0) {
                --this.flowTimer;
            }
            this.fluidLevel.chase((double)this.tank.getFluidAmount(), (double)0.3f, LerpedFloat.Chaser.EXP);
            this.fluidLevel.tickChaser();
        }
    }

    public void findRecipe() {
        this.recipe = null;
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.level, (Predicate)RecipeConditions.isOfType((RecipeType[])new RecipeType[]{TFMGRecipeTypes.CASTING.getType()}));
        for (RecipeHolder recipe1 : list) {
            CastingRecipe testedRecipe = (CastingRecipe)recipe1.value();
            if (!testedRecipe.getIngrenient().test(this.tank.getFluid()) || !this.inventory.isEmpty()) continue;
            this.recipe = testedRecipe;
            return;
        }
    }

    protected Object getRecipeCacheKey() {
        return castingRecipeKey;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private void onFluidChanged(FluidStack stack) {
        this.flowTimer = 10;
        this.sendData();
        this.setChanged();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        TFMGUtils.createItemTooltip((BlockEntity)this, tooltip);
        return true;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.put("Tank", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
        compound.putInt("Timer", this.timer);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.tank.readFromNBT(registries, compound.getCompound("Tank"));
        this.timer = compound.getInt("Timer");
    }
}

