/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types.radial_engine;

import com.drmangotea.tfmg.content.engines.base.EngineBlock;
import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.types.regular_engine.RegularEngineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RadialEngineBlockEntity
extends RegularEngineBlockEntity {
    public RadialEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public boolean canGenerateSpeed() {
        return true;
    }

    @Override
    public boolean hasTwoShafts() {
        return this.engineLength() > 1;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.getBlockPos()).inflate(1.0);
    }

    @Override
    public RegularEngineBlockEntity.EngineType getDefaultEngineType() {
        return RegularEngineBlockEntity.EngineType.RADIAL;
    }

    @Override
    public void setBlockStates(AbstractSmallEngineBlockEntity be, BlockPos last) {
        Direction facing = ((Direction)this.getBlockState().getValue(EngineBlock.SHAFT_FACING)).getOpposite();
        if (this.level.getBlockState(this.getBlockPos().relative(facing)).getBlock() != this.getBlockState().getBlock() && this.level.getBlockState(this.getBlockPos().relative(facing.getOpposite())).getBlock() != this.getBlockState().getBlock()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.level.getBlockState(this.getBlockPos()).setValue(EngineBlock.ENGINE_STATE, (Comparable)((Object)EngineBlock.EngineState.SINGLE)), 2);
            return;
        }
        if (last != null) {
            this.level.setBlock(last, (BlockState)this.level.getBlockState(last).setValue(EngineBlock.ENGINE_STATE, (Comparable)((Object)EngineBlock.EngineState.BACK)), 2);
            return;
        }
        if (be.isController()) {
            this.level.setBlock(be.getBlockPos(), (BlockState)be.getBlockState().setValue(EngineBlock.ENGINE_STATE, (Comparable)((Object)EngineBlock.EngineState.SHAFT)), 2);
        } else {
            this.level.setBlock(be.getBlockPos(), (BlockState)((BlockState)be.getBlockState().setValue(EngineBlock.SHAFT_FACING, (Comparable)((Direction)this.getBlockState().getValue(EngineBlock.SHAFT_FACING)).getOpposite())).setValue(EngineBlock.ENGINE_STATE, (Comparable)((Object)EngineBlock.EngineState.NORMAL)), 2);
        }
    }
}

