/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.engine_controller;

import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlock;
import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlockEntity;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerInputPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerStopControllerPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineStartPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.TransmissionShiftPacket;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGKeys;
import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EngineControllerClientHandler {
    public static Mode MODE = Mode.IDLE;
    public static int PACKET_RATE = 5;
    public static List<Integer> currentlyPressed = new ArrayList<Integer>();
    public static BlockPos controllerPos;
    private static BlockPos selectedLocation;
    private static int packetCooldown;
    private static Vector<KeyMapping> standardControls;

    public static void toggleBindMode(BlockPos location) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.BIND;
            selectedLocation = location;
        } else {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
        }
    }

    public static void toggle() {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            controllerPos = null;
        } else {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
        }
    }

    public static void activateInLectern(BlockPos lecternAt) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            controllerPos = lecternAt;
        }
    }

    public static void deactivateInLectern() {
        if (MODE == Mode.ACTIVE && EngineControllerClientHandler.isController()) {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
        }
    }

    public static boolean isController() {
        return controllerPos != null;
    }

    protected static void onReset() {
        EngineControllerClientHandler.getControls().forEach(kb -> kb.setDown(ControlsUtil.isActuallyPressed((KeyMapping)kb)));
        packetCooldown = 0;
        selectedLocation = BlockPos.ZERO;
        if (EngineControllerClientHandler.isController()) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new EngineControllerStopControllerPacket(controllerPos));
        }
        controllerPos = null;
        if (!currentlyPressed.isEmpty()) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new EngineControllerInputPacket(currentlyPressed, false));
        }
        currentlyPressed.clear();
    }

    public static void tick() {
        BlockEntity blockEntity;
        if (MODE == Mode.IDLE) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ItemStack heldItem = player.getMainHandItem();
        if (player.isSpectator()) {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
            return;
        }
        if (!(EngineControllerClientHandler.isController() || AllItems.LINKED_CONTROLLER.isIn(heldItem) || AllItems.LINKED_CONTROLLER.isIn(heldItem = player.getOffhandItem()))) {
            MODE = Mode.IDLE;
            return;
        }
        if (EngineControllerClientHandler.isController() && ((EngineControllerBlock)((Object)TFMGBlocks.ENGINE_CONTROLLER.get())).getBlockEntityOptional((BlockGetter)mc.level, controllerPos).map(be -> !be.isUsedBy((Player)mc.player)).orElse(true).booleanValue()) {
            EngineControllerClientHandler.deactivateInLectern();
            return;
        }
        if (mc.screen != null) {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
            return;
        }
        if (InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)256)) {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
            return;
        }
        Vector<KeyMapping> controls = EngineControllerClientHandler.getControls();
        ArrayList<Integer> pressedKeys = new ArrayList<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed((KeyMapping)controls.get(i))) continue;
            pressedKeys.add(i);
        }
        ArrayList<Integer> newKeys = new ArrayList<Integer>(pressedKeys);
        List<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (MODE == Mode.ACTIVE) {
            EngineControllerBlockEntity be2;
            if (!releasedKeys.isEmpty()) {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new EngineControllerInputPacket(releasedKeys, false, controllerPos));
                blockEntity = player.level().getBlockEntity(controllerPos);
                if (blockEntity instanceof EngineControllerBlockEntity) {
                    be2 = (EngineControllerBlockEntity)blockEntity;
                    be2.handleInput(releasedKeys, false);
                }
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.level(), (Vec3i)player.blockPosition(), 1.0f, 0.5f, true);
            }
            if (!newKeys.isEmpty()) {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new EngineControllerInputPacket(newKeys, true, controllerPos));
                blockEntity = player.level().getBlockEntity(controllerPos);
                if (blockEntity instanceof EngineControllerBlockEntity) {
                    be2 = (EngineControllerBlockEntity)blockEntity;
                    be2.handleInput(newKeys, true);
                }
                if (newKeys.contains(5) || newKeys.contains(6)) {
                    CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new TransmissionShiftPacket(newKeys, controllerPos));
                    blockEntity = player.level().getBlockEntity(controllerPos);
                    if (blockEntity instanceof EngineControllerBlockEntity) {
                        be2 = (EngineControllerBlockEntity)blockEntity;
                        if (newKeys.contains(6)) {
                            be2.shiftBack();
                        } else {
                            be2.shiftForward();
                        }
                    }
                }
                if (newKeys.contains(8)) {
                    CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new EngineStartPacket(controllerPos));
                    blockEntity = player.level().getBlockEntity(controllerPos);
                    if (blockEntity instanceof EngineControllerBlockEntity) {
                        be2 = (EngineControllerBlockEntity)blockEntity;
                        be2.toggleEngine();
                    }
                }
                packetCooldown = PACKET_RATE;
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.level(), (Vec3i)player.blockPosition(), 1.0f, 0.75f, true);
            }
            if (packetCooldown == 0 && !pressedKeys.isEmpty()) {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new EngineControllerInputPacket(pressedKeys, true, controllerPos));
                blockEntity = player.level().getBlockEntity(controllerPos);
                if (blockEntity instanceof EngineControllerBlockEntity) {
                    be2 = (EngineControllerBlockEntity)blockEntity;
                    be2.handleInput(newKeys, true);
                }
                packetCooldown = PACKET_RATE;
            }
        }
        if (MODE == Mode.BIND) {
            VoxelShape shape = mc.level.getBlockState(selectedLocation).getShape((BlockGetter)mc.level, selectedLocation);
            blockEntity = newKeys.iterator();
            if (blockEntity.hasNext()) {
                Integer integer = (Integer)blockEntity.next();
                LinkBehaviour linkBehaviour = (LinkBehaviour)BlockEntityBehaviour.get((BlockGetter)mc.level, (BlockPos)selectedLocation, (BehaviourType)LinkBehaviour.TYPE);
                if (linkBehaviour != null) {
                    CreateLang.translate((String)"linked_controller.key_bound", (Object[])new Object[]{controls.get(integer).getTranslatedKeyMessage().getString()}).sendStatus((Player)mc.player);
                }
                MODE = Mode.IDLE;
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.setDown(false));
    }

    public static Vector<KeyMapping> getControls() {
        if (standardControls == null) {
            Options gameSettings = Minecraft.getInstance().options;
            standardControls = new Vector(6);
            standardControls.add(gameSettings.keyUp);
            standardControls.add(gameSettings.keyDown);
            standardControls.add(gameSettings.keyLeft);
            standardControls.add(gameSettings.keyRight);
            standardControls.add(gameSettings.keyJump);
            standardControls.add(TFMGKeys.TRANSMISSION_SHIFT_UP.getKeybind());
            standardControls.add(TFMGKeys.TRANSMISSION_SHIFT_DOWN.getKeybind());
            standardControls.add(TFMGKeys.ENGINE_CONTROLLER_CUSTOM_BUTTON.getKeybind());
            standardControls.add(TFMGKeys.ENGINE_START.getKeybind());
            standardControls.add(gameSettings.keyShift);
        }
        return standardControls;
    }

    static {
        selectedLocation = BlockPos.ZERO;
    }

    public static enum Mode {
        IDLE,
        ACTIVE,
        BIND;

    }
}

