/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.network.transformer.large;

import com.drmangotea.tfmg.content.electricity.network.transformer.large.LargeCoilBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.simibubi.create.foundation.block.IBE;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;

public class LargeCoilBlock
extends Block
implements IBE<LargeCoilBlockEntity> {
    public LargeCoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        this.withBlockEntityDo((BlockGetter)level, pos, be -> be.setCapacity(stack));
    }

    public List<ItemStack> getDrops(BlockState p_287732_, LootParams.Builder p_287596_) {
        return Collections.emptyList();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (stack.is(TFMGBlocks.LAMINATED_MAGNETIC_ALLOY_BLOCK.asItem()) && (blockEntity = level.getBlockEntity(pos)) instanceof LargeCoilBlockEntity) {
            LargeCoilBlockEntity be = (LargeCoilBlockEntity)blockEntity;
            return be.createTransformer(player, player.getNearestViewDirection());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity;
        if (!player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof LargeCoilBlockEntity) {
            LargeCoilBlockEntity be = (LargeCoilBlockEntity)blockEntity;
            ItemStack item = TFMGBlocks.LARGE_COIL.asItem().getDefaultInstance();
            item.set(TFMGDataComponents.COIL_TURNS, (Object)be.turns);
            ItemEntity itemToSpawn = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), item);
            if (itemToSpawn.getItem().getCount() > 0) {
                level.addFreshEntity((Entity)itemToSpawn);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public Class<LargeCoilBlockEntity> getBlockEntityClass() {
        return LargeCoilBlockEntity.class;
    }

    public BlockEntityType<? extends LargeCoilBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.LARGE_COIL.get();
    }
}

