/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.network.large_switch;

import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.KineticElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.base.UpdateInFrontPacket;
import com.drmangotea.tfmg.content.electricity.network.large_switch.LargeSwitchBlock;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LargeSwitchBlockEntity
extends KineticElectricBlockEntity {
    public boolean updateInFront = false;
    public boolean closed = false;
    public LerpedFloat visualAngle = LerpedFloat.angular();
    public float angle = 900.0f;
    final boolean isMainPart;

    public LargeSwitchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.isMainPart = (Boolean)state.getValue((Property)LargeSwitchBlock.IS_MAIN_PART);
        this.visualAngle.setValue(90.0);
    }

    @Override
    public int voltageGeneration() {
        LargeSwitchBlockEntity be;
        if (this.isMainPart) {
            return 0;
        }
        int voltageGeneration = 0;
        BlockEntity blockEntity = this.getLevelAccessor().getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite()));
        if (blockEntity instanceof LargeSwitchBlockEntity && (be = (LargeSwitchBlockEntity)blockEntity).getData().getId() != this.getData().getId() && be.getData().getVoltage() != 0 && be.closed) {
            voltageGeneration = Math.max(voltageGeneration, be.data.getVoltage());
            this.getData().getsOutsidePower = true;
        }
        if (voltageGeneration == 0) {
            this.getData().getsOutsidePower = false;
        }
        return voltageGeneration;
    }

    @Override
    public int getMaxCurrent() {
        return 1000;
    }

    @Override
    public int getMaxVoltage() {
        return 100000;
    }

    @Override
    public void lazyTick() {
        BlockEntity blockEntity;
        super.lazyTick();
        if (this.data.notEnoughPower && !((Boolean)this.getBlockState().getValue((Property)LargeSwitchBlock.IS_MAIN_PART)).booleanValue() && (blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite()))) instanceof LargeSwitchBlockEntity) {
            LargeSwitchBlockEntity be = (LargeSwitchBlockEntity)blockEntity;
            be.onPlaced();
        }
    }

    public IElectric getControlledBlock() {
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof LargeSwitchBlockEntity) {
            LargeSwitchBlockEntity be = (LargeSwitchBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    @Override
    public float resistance() {
        int count;
        IElectric be;
        if (!this.isMainPart) {
            return 0.0f;
        }
        if (!this.closed) {
            return 0.0f;
        }
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && (count = this.getBlocksConnectedToNetworkCount(this.getControlledBlock().getData().getId())) != 0) {
            return Math.max(be.getNetworkResistance() * count, 0);
        }
        return 0.0f;
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        if (oldVoltage != this.getData().getVoltage() || oldPower != this.getPowerUsage()) {
            this.updateInFront = true;
        }
        this.sendStuff();
        this.setChanged();
    }

    @Override
    public int powerGeneration() {
        LargeSwitchBlockEntity be;
        if (this.isMainPart) {
            return 0;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite()));
        if (blockEntity instanceof LargeSwitchBlockEntity) {
            LargeSwitchBlockEntity be2 = (LargeSwitchBlockEntity)blockEntity;
            if (be2.data.notEnoughPower) {
                return 0;
            }
        }
        int powerGeneration = 0;
        BlockEntity blockEntity2 = this.getLevelAccessor().getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite()));
        if (blockEntity2 instanceof LargeSwitchBlockEntity && (be = (LargeSwitchBlockEntity)blockEntity2).getData().getId() != this.getData().getId() && be.getData().getVoltage() != 0 && be.closed) {
            powerGeneration = Math.max(powerGeneration, 10000);
            this.getData().getsOutsidePower = true;
        }
        if (powerGeneration == 0) {
            this.getData().getsOutsidePower = false;
        }
        return powerGeneration;
    }

    public void updateInFront() {
        IElectric be;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(this.worldPosition), (CustomPacketPayload)new UpdateInFrontPacket(BlockPos.of((long)this.getPos())));
        }
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId()) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.setChanged();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.visualAngle.chase((double)this.angle / 10.0, 1.0, LerpedFloat.Chaser.EXP);
            this.visualAngle.tickChaser();
        }
        if (this.updateInFront) {
            this.updateInFront();
            this.updateInFront = false;
        }
        if (!this.isMainPart) {
            return;
        }
        if (this.angle < 0.0f) {
            this.angle = 0.0f;
        }
        if (this.angle > 900.0f) {
            this.angle = 900.0f;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.getSpeed() < 0.0f && this.angle != 900.0f) {
            this.angle += this.getArmSpeed();
        }
        if (this.getSpeed() > 0.0f && this.angle != 0.0f) {
            this.angle -= this.getArmSpeed();
        }
        boolean oldValue = this.closed;
        if (this.data.voltage < 1000) {
            this.closed = this.angle == 0.0f;
        } else {
            boolean bl = this.closed = this.angle < (float)this.data.voltage / 700.0f;
        }
        if (oldValue != this.closed) {
            this.updateInFront();
        }
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public float getArmSpeed() {
        return Math.abs(this.getSpeed()) * 0.3f;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite() && (Boolean)this.getBlockState().getValue((Property)LargeSwitchBlock.IS_MAIN_PART) != false || direction == this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING) && (Boolean)this.getBlockState().getValue((Property)LargeSwitchBlock.IS_MAIN_PART) == false;
    }
}

