/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.measurement;

import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.storage.AccumulatorBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VoltMeterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public LerpedFloat angle = LerpedFloat.angular();
    public float value = 0.0f;
    public MeasureMode mode = MeasureMode.VOLTAGE;

    public VoltMeterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void lazyTick() {
        super.lazyTick();
        BlockEntity beBehind = this.level.getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()));
        if (beBehind instanceof IElectric) {
            IElectric be = (IElectric)beBehind;
            this.value = Math.min(this.getUnit(be), (float)this.mode.defaultRange);
        } else {
            this.value = 0.0f;
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.mode != MeasureMode.VOLTAGE) {
            tag.putString("mode", this.mode.toString());
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (!tag.getString("mode").isEmpty()) {
            this.mode = MeasureMode.valueOf(tag.getString("mode"));
        }
    }

    public float getUnit(IElectric be) {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> be.getData().getVoltage();
            case 2 -> be.getCurrent();
            case 3 -> be.resistance();
            case 4 -> {
                if (be.powerGeneration() > 0) {
                    yield be.powerGeneration();
                }
                yield be.getPowerUsage();
            }
            case 5 -> be.getNetworkPowerUsage();
            case 6 -> be.getNetworkPowerGeneration();
            case 7 -> {
                if (be instanceof AccumulatorBlockEntity) {
                    AccumulatorBlockEntity accumulator = (AccumulatorBlockEntity)be;
                    BlockEntity var4_3 = this.level.getBlockEntity(accumulator.controller);
                    if (var4_3 instanceof AccumulatorBlockEntity) {
                        AccumulatorBlockEntity controllerBE = (AccumulatorBlockEntity)var4_3;
                        yield controllerBE.energy.getEnergyStored();
                    }
                    yield 0.0f;
                }
                yield 0.0f;
            }
            case 8 -> 0.0f;
        };
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            return;
        }
        float value = Math.abs(this.value) / (float)this.getRange();
        if (value > 1.0f) {
            value = 1.0f;
        }
        float targetAngle = Math.abs(value * 180.0f);
        this.angle.chase((double)Math.min(Math.abs(targetAngle), 180.0f), (double)0.05f, LerpedFloat.Chaser.EXP);
        this.angle.tickChaser();
    }

    public int getRange() {
        return this.mode.defaultRange;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TFMGTexts.Voltmeter.mode(this.mode.langKey).forGoggles(tooltip, 1);
        TFMGTexts.Voltmeter.value(this.value, this.mode.unit).forGoggles(tooltip, 1);
        TFMGTexts.Voltmeter.range(this.mode.defaultRange).forGoggles(tooltip, 1);
        return true;
    }

    public static enum MeasureMode {
        VOLTAGE("V", 500),
        HIGH_VOLTAGE("V", 10000),
        CURRENT("A", 16),
        RESISTANCE("\u03a9", 500),
        POWER("W", 5000),
        NETWORK_POWER_USAGE("W", 50000),
        NETWORK_POWER_GENERATION("W", 50000),
        CAPACITY("Fe", 300000),
        FALLBACK("", 0);

        public final String unit;
        public final int defaultRange;
        public final String langKey;

        private MeasureMode(String unit, int defaultRange) {
            this.unit = unit;
            this.defaultRange = defaultRange;
            this.langKey = "goggles.voltmeter.mode." + this.name().toLowerCase();
        }
    }
}

