/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.copycat_cable;

import com.drmangotea.tfmg.content.electricity.base.ElectricBlockValues;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CopycatCableBlockEntity
extends CopycatBlockEntity
implements IElectric,
IHaveHoveringInformation {
    public ElectricBlockValues data = new ElectricBlockValues(this.getPos());

    public CopycatCableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.data.connectNextTick = true;
    }

    @Override
    public LevelAccessor getLevelAccessor() {
        return this.level;
    }

    public void lazyTick() {
        super.lazyTick();
        this.lazyTickElectricity();
    }

    @Override
    public ElectricBlockValues getData() {
        return this.data;
    }

    @Override
    public void sendStuff() {
        this.sendData();
    }

    @Override
    public long getPos() {
        return this.getBlockPos().asLong();
    }

    public void remove() {
        super.remove();
        this.onRemoved();
    }

    public void tick() {
        super.tick();
        this.tickElectricity();
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (this.getMaterial() != null && !clientPacket) {
            BlockState blockState = this.getBlockState();
            if (blockState == null) {
                return;
            }
            Block block = blockState.getBlock();
            if (!(block instanceof CopycatBlock)) {
                return;
            }
            CopycatBlock cb = (CopycatBlock)block;
            BlockState acceptedBlockState = cb.getAcceptedBlockState(this.level, this.worldPosition, ItemStack.EMPTY, null);
            if (acceptedBlockState != null && this.getMaterial().is(acceptedBlockState.getBlock())) {
                return;
            }
            this.setMaterial(AllBlocks.COPYCAT_BASE.getDefaultState());
        }
        this.readElectricity(compound, clientPacket);
    }
}

