/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.cables;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.base.blocks.WallMountBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlockEntity;
import com.drmangotea.tfmg.content.electricity.connection.cables.IHaveCables;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CableConnectorBlock
extends WallMountBlock
implements IBE<CableConnectorBlockEntity>,
IHaveCables {
    public static final BooleanProperty EXTENSION = BooleanProperty.create((String)"extension");

    public CableConnectorBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)EXTENSION, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState blockState1, boolean b) {
        this.updateExtension(level, state, pos);
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
        BlockPos below = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
        BlockState stateBelow = level.getBlockState(below);
        if (stateBelow.getBlock() instanceof IHaveCables) {
            this.updateExtension(level, stateBelow, below);
        }
        super.onPlace(state, level, pos, blockState1, b);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.updateExtension((Level)level, state, pos);
        super.onNeighborChange(state, level, pos, neighbor);
    }

    public void updateExtension(Level level, BlockState state, BlockPos pos) {
        BlockPos above = pos.relative((Direction)state.getValue((Property)FACING));
        BlockState stateAbove = level.getBlockState(above);
        if (stateAbove.getBlock() instanceof IHaveCables && stateAbove.getValue((Property)FACING) == state.getValue((Property)FACING)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EXTENSION, (Comparable)Boolean.valueOf(true)));
        } else {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EXTENSION, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{EXTENSION});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)pState.getValue((Property)EXTENSION)).booleanValue()) {
            return TFMGShapes.CABLE_CONNECTOR_MIDDLE.get((Direction)pState.getValue((Property)FACING));
        }
        return TFMGShapes.CABLE_CONNECTOR.get((Direction)pState.getValue((Property)FACING));
    }

    public Class<CableConnectorBlockEntity> getBlockEntityClass() {
        return CableConnectorBlockEntity.class;
    }

    public BlockEntityType<? extends CableConnectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.CABLE_CONNECTOR.get();
    }
}

