/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.decoration.kinetics.cogs;

import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public class TFMGCogwheelVisual {
    public static BlockEntityVisual<BracketedKineticBlockEntity> create(VisualizationContext context, BracketedKineticBlockEntity blockEntity, float partialTick) {
        if (ICogWheel.isLargeCog((BlockState)blockEntity.getBlockState())) {
            return new LargeCogVisual(context, blockEntity, partialTick);
        }
        Model model = TFMGBlocks.STEEL_COGWHEEL.is((Object)blockEntity.getBlockState().getBlock()) ? Models.partial((PartialModel)TFMGPartialModels.STEEL_COGHWEEL) : Models.partial((PartialModel)TFMGPartialModels.ALUMINUM_COGHWEEL);
        return new SingleAxisRotatingVisual(context, (KineticBlockEntity)blockEntity, partialTick, model);
    }

    public static class LargeCogVisual
    extends SingleAxisRotatingVisual<BracketedKineticBlockEntity> {
        protected final RotatingInstance additionalShaft;

        private LargeCogVisual(VisualizationContext context, BracketedKineticBlockEntity blockEntity, float partialTick) {
            super(context, (KineticBlockEntity)blockEntity, partialTick, LargeCogVisual.getLargeModel(blockEntity));
            Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)blockEntity);
            this.additionalShaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.COGWHEEL_SHAFT)).createInstance();
            this.additionalShaft.rotateToFace(axis).setup((KineticBlockEntity)blockEntity).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos)).setPosition((Vec3i)this.getVisualPosition()).setChanged();
        }

        public static Model getLargeModel(BracketedKineticBlockEntity blockEntity) {
            if (TFMGBlocks.LARGE_STEEL_COGWHEEL.is((Object)blockEntity.getBlockState().getBlock())) {
                return Models.partial((PartialModel)TFMGPartialModels.LARGE_STEEL_COGHWEEL);
            }
            return Models.partial((PartialModel)TFMGPartialModels.LARGE_ALUMINUM_COGHWEEL);
        }

        public void update(float pt) {
            super.update(pt);
            this.additionalShaft.setup((KineticBlockEntity)this.blockEntity).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.rotationAxis(), (BlockPos)this.pos)).setChanged();
        }

        public void updateLight(float partialTick) {
            super.updateLight(partialTick);
            this.relight(new FlatLit[]{this.additionalShaft});
        }

        protected void _delete() {
            super._delete();
            this.additionalShaft.delete();
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept((Instance)this.additionalShaft);
        }
    }
}

