/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg;

import com.drmangotea.tfmg.base.TFMGBoilerHeaters;
import com.drmangotea.tfmg.base.TFMGContraptions;
import com.drmangotea.tfmg.base.TFMGCreativeTabs;
import com.drmangotea.tfmg.base.TFMGRegistrate;
import com.drmangotea.tfmg.base.fluid.TFMGFluidInteractions;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipes;
import com.drmangotea.tfmg.content.electricity.base.ElectricNetworkManager;
import com.drmangotea.tfmg.content.engines.fuels.BaseFuelTypes;
import com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades.fire.TFMGColoredFires;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.base.TestSavedDataManager;
import com.drmangotea.tfmg.datagen.TFMGDatagen;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGCableTypes;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGDisplaySources;
import com.drmangotea.tfmg.registry.TFMGElectrodes;
import com.drmangotea.tfmg.registry.TFMGEncasedBlocks;
import com.drmangotea.tfmg.registry.TFMGEntityTypes;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGMenuTypes;
import com.drmangotea.tfmg.registry.TFMGMobEffects;
import com.drmangotea.tfmg.registry.TFMGMountedStorageTypes;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.drmangotea.tfmg.registry.TFMGPaletteBlocks;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.drmangotea.tfmg.registry.TFMGParticleTypes;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.drmangotea.tfmg.worldgen.TFMGFeatures;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="tfmg")
public class TFMG {
    public static final String MOD_ID = "tfmg";
    public static final ElectricNetworkManager NETWORK_MANAGER = new ElectricNetworkManager();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final TestSavedDataManager DEPOSITS = new TestSavedDataManager();
    public static final TFMGRegistrate REGISTRATE = TFMGRegistrate.create("tfmg").setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));

    public TFMG(IEventBus modEventBus, ModContainer modContainer) {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        REGISTRATE.registerEventListeners(modEventBus);
        TFMGSoundEvents.prepare();
        TFMGElectrodes.init();
        TFMGCableTypes.init();
        TFMGDisplaySources.init();
        TFMGCreativeTabs.register(modEventBus);
        TFMGBlocks.init();
        TFMGPipes.init();
        TFMGBlockEntities.init();
        TFMGItems.init();
        TFMGEntityTypes.init();
        TFMGPartialModels.init();
        TFMGFluids.init();
        TFMGMenuTypes.init();
        TFMGEncasedBlocks.init();
        TFMGPaletteBlocks.init();
        TFMGParticleTypes.register(modEventBus);
        TFMGDataComponents.register(modEventBus);
        TFMGMobEffects.register(modEventBus);
        TFMGRecipeTypes.register(modEventBus);
        TFMGColoredFires.register(modEventBus);
        TFMGFeatures.register(modEventBus);
        TFMGMountedStorageTypes.register();
        modEventBus.addListener(TFMG::onRegister);
        TFMGPackets.register();
        TFMGConfigs.register(modLoadingContext, modContainer);
        modEventBus.addListener(EventPriority.HIGHEST, TFMGDatagen::gatherDataHighPriority);
        modEventBus.addListener(EventPriority.LOWEST, TFMGDatagen::gatherData);
        modEventBus.addListener(TFMGSoundEvents::register);
        modEventBus.addListener(TFMG::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(TFMGCreativeTabs::addCreative);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFMGColoredFires.GREEN_FIRE.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFMGColoredFires.BLUE_FIRE.get()), (RenderType)RenderType.cutout());
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        TFMGFluidInteractions.registerFluidInteractions();
        event.enqueueWork(() -> {
            BaseFuelTypes.register();
            TFMGBoilerHeaters.registerDefaults();
        });
    }

    public static void onRegister(RegisterEvent event) {
        TFMGContraptions.prepare();
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static TFMGRegistrate registrate() {
        return REGISTRATE;
    }
}

